/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.entity.projectile.EntityBoomerang;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.WMItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class MeleeCompBoomerang
extends MeleeComponent {
    public static final String WOOD_ID = "boomerang.wood";
    public static final ItemMelee WOOD_ITEM = WMItemBuilder.createStandardBoomerang((Tier)Tiers.WOOD);
    public static final String STONE_ID = "boomerang.stone";
    public static final ItemMelee STONE_ITEM = WMItemBuilder.createStandardBoomerang((Tier)Tiers.STONE);
    public static final String IRON_ID = "boomerang.iron";
    public static final ItemMelee IRON_ITEM = WMItemBuilder.createStandardBoomerang((Tier)Tiers.IRON);
    public static final String GOLD_ID = "boomerang.gold";
    public static final ItemMelee GOLD_ITEM = WMItemBuilder.createStandardBoomerang((Tier)Tiers.GOLD);
    public static final String DIAMOND_ID = "boomerang.diamond";
    public static final ItemMelee DIAMOND_ITEM = WMItemBuilder.createStandardBoomerang((Tier)Tiers.DIAMOND);
    public static final String NETHERITE_ID = "boomerang.netherite";
    public static final ItemMelee NETHERITE_ITEM = WMItemBuilder.createStandardBoomerang((Tier)Tiers.NETHERITE);

    public MeleeCompBoomerang(Tier itemTier) {
        super(MeleeComponent.MeleeSpecs.BOOMERANG, itemTier);
    }

    @Override
    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        Player player;
        if (itemstack.m_41619_()) {
            return;
        }
        int j = this.getUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) < 0.1f) {
            return;
        }
        boolean crit = false;
        if (f > 1.5f) {
            f = 1.5f;
            crit = true;
        }
        f *= 1.5f;
        if (!world.f_46443_) {
            EntityBoomerang entityboomerang = new EntityBoomerang(world, entityliving, itemstack.m_41777_());
            entityboomerang.m_37251_((Entity)entityliving, entityliving.m_146909_(), entityliving.m_146908_(), 0.0f, f, 5.0f);
            entityboomerang.m_36762_(crit);
            entityboomerang.m_36735_(EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)itemstack));
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)itemstack) > 0) {
                entityboomerang.m_20254_(100);
            }
            world.m_7967_((Entity)entityboomerang);
        }
        world.m_6263_(null, entityliving.m_20185_(), entityliving.m_20186_(), entityliving.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 0.6f, 1.0f / (entityliving.m_21187_().nextFloat() * 0.4f + 1.0f));
        if (!(entityliving instanceof Player) || !(player = (Player)entityliving).m_7500_()) {
            WMItem.decrStackSize(itemstack, 1, entityliving);
        }
    }

    @Override
    public int getUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(ItemStack itemstack, Level world, Player entityplayer, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        entityplayer.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }
}

