/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.item.IExtendedReachItem;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;

public class MeleeCompHalberd
extends MeleeComponent
implements IExtendedReachItem {
    public static final String WOOD_ID = "halberd.wood";
    public static final ItemMelee WOOD_ITEM = WMItemBuilder.createStandardHalberd((Tier)Tiers.WOOD);
    public static final String STONE_ID = "halberd.stone";
    public static final ItemMelee STONE_ITEM = WMItemBuilder.createStandardHalberd((Tier)Tiers.STONE);
    public static final String IRON_ID = "halberd.iron";
    public static final ItemMelee IRON_ITEM = WMItemBuilder.createStandardHalberd((Tier)Tiers.IRON);
    public static final String GOLD_ID = "halberd.gold";
    public static final ItemMelee GOLD_ITEM = WMItemBuilder.createStandardHalberd((Tier)Tiers.GOLD);
    public static final String DIAMOND_ID = "halberd.diamond";
    public static final ItemMelee DIAMOND_ITEM = WMItemBuilder.createStandardHalberd((Tier)Tiers.DIAMOND);
    public static final String NETHERITE_ID = "halberd.netherite";
    public static final ItemMelee NETHERITE_ITEM = WMItemBuilder.createStandardHalberd((Tier)Tiers.NETHERITE);

    public static boolean getHalberdState(ItemStack itemstack) {
        return itemstack.m_41782_() && itemstack.m_41783_().m_128471_("halb");
    }

    public static void setHalberdState(ItemStack itemstack, boolean flag) {
        if (!itemstack.m_41782_()) {
            itemstack.m_41751_(new CompoundTag());
        }
        itemstack.m_41783_().m_128379_("halb", flag);
    }

    public MeleeCompHalberd(Tier itemTier) {
        super(MeleeComponent.MeleeSpecs.HALBERD, itemTier);
    }

    @Override
    public float getAttackDelay(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        float ad = super.getAttackDelay(itemstack, entityliving, attacker);
        return MeleeCompHalberd.getHalberdState(itemstack) ? 0.0f : ad;
    }

    @Override
    public float getKnockBack(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        float kb = super.getKnockBack(itemstack, entityliving, attacker);
        return MeleeCompHalberd.getHalberdState(itemstack) ? kb / 2.0f : kb;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(ItemStack itemstack, Level world, Player entityplayer, InteractionHand hand) {
        MeleeCompHalberd.setHalberdState(itemstack, !MeleeCompHalberd.getHalberdState(itemstack));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public float getExtendedReach(Level world, LivingEntity living, ItemStack itemstack) {
        return 4.0f;
    }
}

