/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.EntitySpear;
import ckathode.weaponmod.item.IExtendedReachItem;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class MeleeCompSpear
extends MeleeComponent
implements IExtendedReachItem {
    public static final String WOOD_ID = "spear.wood";
    public static final ItemMelee WOOD_ITEM = WMItemBuilder.createStandardSpear((Tier)Tiers.WOOD);
    public static final String STONE_ID = "spear.stone";
    public static final ItemMelee STONE_ITEM = WMItemBuilder.createStandardSpear((Tier)Tiers.STONE);
    public static final String IRON_ID = "spear.iron";
    public static final ItemMelee IRON_ITEM = WMItemBuilder.createStandardSpear((Tier)Tiers.IRON);
    public static final String GOLD_ID = "spear.gold";
    public static final ItemMelee GOLD_ITEM = WMItemBuilder.createStandardSpear((Tier)Tiers.GOLD);
    public static final String DIAMOND_ID = "spear.diamond";
    public static final ItemMelee DIAMOND_ITEM = WMItemBuilder.createStandardSpear((Tier)Tiers.DIAMOND);
    public static final String NETHERITE_ID = "spear.netherite";
    public static final ItemMelee NETHERITE_ITEM = WMItemBuilder.createStandardSpear((Tier)Tiers.NETHERITE);

    public MeleeCompSpear(Tier itemTier) {
        super(MeleeComponent.MeleeSpecs.SPEAR, itemTier);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(ItemStack itemstack, Level world, Player entityplayer, InteractionHand hand) {
        if (!WeaponModConfig.get().canThrowSpear) {
            return super.use(itemstack, world, entityplayer, hand);
        }
        if (!world.f_46443_) {
            EntitySpear entityspear = new EntitySpear(world, (LivingEntity)entityplayer, itemstack.m_41777_());
            entityspear.m_37251_((Entity)entityplayer, entityplayer.m_146909_(), entityplayer.m_146908_(), 0.0f, 0.8f, 3.0f);
            entityspear.m_36735_(EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)itemstack));
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)itemstack) > 0) {
                entityspear.m_20254_(100);
            }
            world.m_7967_((Entity)entityspear);
        }
        world.m_6263_(null, entityplayer.m_20185_(), entityplayer.m_20186_(), entityplayer.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (entityplayer.m_21187_().nextFloat() * 0.4f + 0.8f));
        if (!entityplayer.m_7500_()) {
            itemstack = itemstack.m_41777_();
            itemstack.m_41774_(1);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public UseAnim getUseAnimation(ItemStack itemstack) {
        return WeaponModConfig.get().canThrowSpear ? UseAnim.NONE : super.getUseAnimation(itemstack);
    }

    @Override
    public float getExtendedReach(Level world, LivingEntity living, ItemStack itemstack) {
        return 4.0f;
    }
}

