/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.IExtendedReachItem;
import ckathode.weaponmod.item.IItemWeapon;
import com.google.common.collect.Multimap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MeleeComponent
extends AbstractWeaponComponent {
    public final MeleeSpecs meleeSpecs;
    public final Tier weaponMaterial;

    public MeleeComponent(MeleeSpecs meleespecs, Tier itemTier) {
        this.meleeSpecs = meleespecs;
        this.weaponMaterial = itemTier;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public Item.Properties setProperties(Item.Properties properties) {
        return properties.m_41499_(this.weaponMaterial == null ? this.meleeSpecs.durabilityBase : (int)((float)this.meleeSpecs.durabilityBase + (float)this.weaponMaterial.m_6609_() * this.meleeSpecs.durabilityMult));
    }

    @Override
    public float getDamage() {
        if (this.weaponMaterial == null) {
            return 0.0f;
        }
        return this.weaponMaterial.m_6631_() * this.meleeSpecs.damageMult;
    }

    @Override
    public float getEntityDamage() {
        return this.meleeSpecs.damageBase + this.getDamage();
    }

    @Override
    public float getDestroySpeed(ItemStack itemstack, BlockState block) {
        if (this.canHarvestBlock(block)) {
            return this.meleeSpecs.blockDamage * 10.0f;
        }
        Material material = block.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && material != Material.f_76301_ && material != Material.f_76274_ && material != Material.f_76285_ ? 1.0f : this.meleeSpecs.blockDamage;
    }

    @Override
    public boolean canHarvestBlock(BlockState state) {
        Block block = state.m_60734_();
        return block == Blocks.f_50033_;
    }

    @Override
    public boolean mineBlock(ItemStack itemstack, Level world, BlockState block, BlockPos pos, LivingEntity entityliving) {
        if (block.m_60800_((BlockGetter)world, pos) != 0.0f) {
            itemstack.m_41622_(this.meleeSpecs.dmgFromBlock, entityliving, s -> s.m_21190_(InteractionHand.MAIN_HAND));
        }
        return true;
    }

    @Override
    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        int n = entityliving.f_19802_;
        Objects.requireNonNull(entityliving);
        if (n == 20) {
            float kb = this.getKnockBack(itemstack, entityliving, attacker);
            PhysHelper.knockBack(entityliving, attacker, kb);
            if (this.meleeSpecs.attackDelay >= 3.0f) {
                entityliving.f_19802_ += (int)this.getAttackDelay(itemstack, entityliving, attacker);
            } else {
                float f = this.meleeSpecs.attackDelay < 1.0f ? 1.2f : 2.0f;
                entityliving.f_19802_ -= (int)(f / this.getAttackDelay(itemstack, entityliving, attacker));
            }
        }
        itemstack.m_41622_(this.meleeSpecs.dmgFromEntity, attacker, s -> s.m_21190_(InteractionHand.MAIN_HAND));
        return true;
    }

    @Override
    public float getAttackDelay(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        return this.meleeSpecs.attackDelay;
    }

    @Override
    public float getKnockBack(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        return this.meleeSpecs.getKnockBack(this.weaponMaterial);
    }

    @Override
    public int getEnchantmentValue() {
        return this.weaponMaterial == null ? 1 : this.weaponMaterial.m_6601_();
    }

    @Override
    public void addItemAttributeModifiers(Multimap<Attribute, AttributeModifier> multimap) {
        MeleeComponent meleeComponent;
        float dmg = this.getEntityDamage();
        if (dmg > 0.0f || this.meleeSpecs.damageMult > 0.0f) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(IItemWeapon.ATTACK_DAMAGE_MODIFIER, "Weapon attack damage modifier", (double)dmg, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(IItemWeapon.ATTACK_SPEED_MODIFIER, "Weapon attack speed modifier", (double)(-this.meleeSpecs.attackDelay), AttributeModifier.Operation.ADDITION));
        }
        if (this.meleeSpecs.getKnockBack(this.weaponMaterial) != 0.4f) {
            multimap.put((Object)WeaponModAttributes.WEAPON_KNOCKBACK, (Object)new AttributeModifier(IItemWeapon.KNOCKBACK_MODIFIER, "Weapon knockback modifier", (double)(this.meleeSpecs.getKnockBack(this.weaponMaterial) - 0.4f), AttributeModifier.Operation.ADDITION));
        }
        if ((meleeComponent = this) instanceof IExtendedReachItem) {
            IExtendedReachItem ieri = (IExtendedReachItem)((Object)meleeComponent);
            try {
                multimap.put((Object)WeaponModAttributes.WEAPON_REACH, (Object)new AttributeModifier(IItemWeapon.REACH_MODIFIER, "Weapon reach modifier", (double)(ieri.getExtendedReach(null, null, null) - 3.0f), AttributeModifier.Operation.ADDITION));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemstack, Player player, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            PhysHelper.prepareKnockbackOnEntity((LivingEntity)player, livingEntity);
        }
        return false;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BLOCK;
    }

    @Override
    public int getUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(ItemStack itemstack, Level world, Player entityplayer, InteractionHand hand) {
        if (this.getUseAnimation(itemstack) != UseAnim.NONE) {
            entityplayer.m_6672_(hand);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    @Override
    public void onUsingTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
    }

    @Override
    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
    }

    @Override
    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int i, boolean flag) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderCooldown() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCooldown() {
        return 0.0f;
    }

    public static enum MeleeSpecs {
        SPEAR(0, 1.0f, 3.0f, 1.0f, 1.0f, 0.2f, 1, 2, 2.7f),
        HALBERD(0, 1.0f, 4.0f, 1.0f, 1.5f, 0.6f, 1, 2, 3.2f),
        BATTLEAXE(0, 1.0f, 3.0f, 1.0f, 1.5f, 0.5f, 1, 2, 3.0f),
        WARHAMMER(0, 1.0f, 4.0f, 1.0f, 1.0f, 0.7f, 1, 2, 3.0f),
        KNIFE(0, 0.5f, 3.0f, 1.0f, 1.5f, 0.2f, 1, 2, 2.0f),
        KATANA(0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1, 2, 0.2f),
        FIREROD(1, 0.0f, 1.0f, 0.0f, 1.0f, 0.4f, 2, 0, 0.0f),
        BOOMERANG(0, 0.5f, 2.0f, 1.0f, 1.0f, 0.4f, 1, 1, 2.0f),
        NONE(0, 1.0f, 1.0f, 0.0f, 1.0f, 0.4f, 0, 0, 0.0f);

        public final int durabilityBase;
        public final float durabilityMult;
        public final float damageBase;
        public final float damageMult;
        public final float blockDamage;
        public final float knockback;
        public final float attackDelay;
        public final int dmgFromEntity;
        public final int dmgFromBlock;

        private MeleeSpecs(int durbase, float durmult, float dmgbase, float dmgmult, float blockdmg, float knockbck, int dmgfromentity, int dmgfromblock, float attackdelay) {
            this.durabilityBase = durbase;
            this.durabilityMult = durmult;
            this.damageBase = dmgbase;
            this.damageMult = dmgmult;
            this.blockDamage = blockdmg;
            this.knockback = knockbck;
            this.dmgFromEntity = dmgfromentity;
            this.dmgFromBlock = dmgfromblock;
            this.attackDelay = attackdelay;
        }

        public float getKnockBack(Tier material) {
            return material == Tiers.GOLD ? this.knockback * 1.5f : this.knockback;
        }
    }
}

