/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.entity.projectile.EntityBlowgunDart;
import ckathode.weaponmod.item.DartType;
import ckathode.weaponmod.item.ItemBlowgunDart;
import ckathode.weaponmod.item.ItemShooter;
import ckathode.weaponmod.item.RangedComponent;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RangedCompBlowgun
extends RangedComponent {
    public static final String ID = "blowgun";
    public static final ItemShooter ITEM = WMItemBuilder.createStandardBlowgun();

    public RangedCompBlowgun() {
        super(RangedComponent.RangedSpecs.BLOWGUN);
    }

    @Override
    public void effectReloadDone(ItemStack itemstack, Level world, LivingEntity entityliving) {
        entityliving.m_6674_(InteractionHand.MAIN_HAND);
        world.m_6263_(null, entityliving.m_20185_(), entityliving.m_20186_(), entityliving.m_20189_(), SoundEvents.f_11762_, SoundSource.PLAYERS, 0.8f, 1.0f / (entityliving.m_21187_().nextFloat() * 0.4f + 0.4f));
    }

    @Override
    public void fire(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        ItemStack dartstack;
        if (!(entityliving instanceof Player)) {
            return;
        }
        Player entityplayer = (Player)entityliving;
        int j = this.getUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        if (f < 0.1f) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if ((dartstack = this.findAmmo(entityplayer)).m_41619_() && entityplayer.m_7500_()) {
            dartstack = new ItemStack((ItemLike)ItemBlowgunDart.ITEMS.get(DartType.damage), 1);
        }
        ItemStack dartStackCopy = dartstack.m_41777_();
        if (!entityplayer.m_7500_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemstack) == 0) {
            this.consumeAmmo(entityplayer);
        }
        if (!world.f_46443_) {
            EntityBlowgunDart entityblowgundart = new EntityBlowgunDart(world, (LivingEntity)entityplayer);
            entityblowgundart.m_37251_((Entity)entityplayer, entityplayer.m_146909_(), entityplayer.m_146908_(), 0.0f, f * 1.5f, 1.0f);
            Item item = dartStackCopy.m_41720_();
            if (item instanceof ItemBlowgunDart) {
                ItemBlowgunDart dart = (ItemBlowgunDart)item;
                entityblowgundart.setDartEffectType(dart.getDartType());
            }
            this.applyProjectileEnchantments(entityblowgundart, itemstack);
            world.m_7967_((Entity)entityblowgundart);
        }
        int damage = 1;
        if (itemstack.m_41773_() + damage < itemstack.m_41776_()) {
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
        }
        itemstack.m_41622_(damage, (LivingEntity)entityplayer, s -> s.m_21190_(s.m_7655_()));
        this.postShootingEffects(itemstack, (LivingEntity)entityplayer, world);
        RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
    }

    @Override
    public boolean hasAmmoAndConsume(ItemStack itemstack, Level world, LivingEntity entityliving) {
        if (!(entityliving instanceof Player)) {
            return false;
        }
        Player player = (Player)entityliving;
        return this.hasAmmo(itemstack, world, player);
    }

    @Override
    public void soundEmpty(ItemStack itemstack, Level world, Player entityplayer) {
        world.m_6263_(null, entityplayer.m_20185_(), entityplayer.m_20186_(), entityplayer.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (entityplayer.m_21187_().nextFloat() * 0.2f + 0.5f));
    }

    @Override
    public void soundCharge(ItemStack itemstack, Level world, Player entityplayer) {
        world.m_6263_(null, entityplayer.m_20185_(), entityplayer.m_20186_(), entityplayer.m_20189_(), SoundEvents.f_12320_, SoundSource.PLAYERS, 1.0f, 1.0f / (entityplayer.m_21187_().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public void effectShoot(Level world, double x, double y, double z, float yaw, float pitch) {
        world.m_6263_(null, x, y, z, SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.m_5822_().nextFloat() * 0.2f + 0.5f));
        float particleX = -Mth.m_14031_((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float particleY = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180))) + 1.6f;
        float particleZ = Mth.m_14089_((float)((yaw + 23.0f) * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, x + (double)particleX, y + (double)particleY, z + (double)particleZ, 0.0, 0.0, 0.0);
    }

    @Override
    public void effectPlayer(ItemStack itemstack, Player entityplayer, Level world) {
    }

    @Override
    public float getMaxZoom() {
        return 0.1f;
    }
}

