/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.entity.projectile.EntityCrossbowBolt;
import ckathode.weaponmod.item.ItemShooter;
import ckathode.weaponmod.item.RangedComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RangedCompCrossbow
extends RangedComponent {
    public static final String ID = "crossbow";
    public static final ItemShooter ITEM = WMItemBuilder.createStandardCrossbow();

    public RangedCompCrossbow() {
        super(RangedComponent.RangedSpecs.CROSSBOW);
    }

    @Override
    public void effectReloadDone(ItemStack itemstack, Level world, LivingEntity entityliving) {
        entityliving.m_6674_(InteractionHand.MAIN_HAND);
        world.m_6263_(null, entityliving.m_20185_(), entityliving.m_20186_(), entityliving.m_20189_(), SoundEvents.f_11762_, SoundSource.PLAYERS, 0.8f, 1.0f / (entityliving.m_21187_().nextFloat() * 0.4f + 0.4f));
    }

    public void resetReload(Level world, ItemStack itemstack) {
        RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
    }

    @Override
    public void fire(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        int j = this.getUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        f += 0.02f;
        if (!world.f_46443_) {
            EntityCrossbowBolt entitybolt = new EntityCrossbowBolt(world, entityliving);
            entitybolt.m_37251_((Entity)entityliving, entityliving.m_146909_(), entityliving.m_146908_(), 0.0f, 5.0f, 1.5f / f);
            this.applyProjectileEnchantments(entitybolt, itemstack);
            world.m_7967_((Entity)entitybolt);
        }
        int damage = 1;
        if (itemstack.m_41773_() + damage < itemstack.m_41776_()) {
            this.resetReload(world, itemstack);
        }
        itemstack.m_41622_(damage, entityliving, s -> s.m_21190_(s.m_7655_()));
        this.postShootingEffects(itemstack, entityliving, world);
        this.resetReload(world, itemstack);
    }

    @Override
    public void effectPlayer(ItemStack itemstack, Player entityplayer, Level world) {
        entityplayer.m_146926_(entityplayer.m_146909_() - (entityplayer.m_6144_() ? 4.0f : 8.0f));
    }

    @Override
    public void effectShoot(Level world, double x, double y, double z, float yaw, float pitch) {
        world.m_6263_(null, x, y, z, SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.m_5822_().nextFloat() * 0.4f + 0.8f));
    }
}

