/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.ReloadHelper;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.DartType;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.WMItem;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RangedComponent
extends AbstractWeaponComponent {
    protected static final int MAX_DELAY = 72000;
    public final RangedSpecs rangedSpecs;

    public static boolean isReloaded(ItemStack itemstack) {
        return ReloadHelper.getReloadState(itemstack).isReloaded();
    }

    public static boolean isReadyToFire(ItemStack itemstack) {
        return ReloadHelper.getReloadState(itemstack) == ReloadHelper.ReloadState.STATE_READY;
    }

    public static void setReloadState(ItemStack itemstack, ReloadHelper.ReloadState state) {
        ReloadHelper.setReloadState(itemstack, state);
    }

    public RangedComponent(RangedSpecs rangedspecs) {
        this.rangedSpecs = rangedspecs;
    }

    @Override
    protected void onSetItem() {
    }

    @Override
    public Item.Properties setProperties(Item.Properties properties) {
        return properties.m_41499_(this.rangedSpecs.durability);
    }

    @Override
    public float getDamage() {
        return 0.0f;
    }

    @Override
    public float getEntityDamage() {
        return 0.0f;
    }

    @Override
    public float getDestroySpeed(ItemStack itemstack, BlockState block) {
        return 0.0f;
    }

    @Override
    public boolean canHarvestBlock(BlockState block) {
        return false;
    }

    @Override
    public boolean mineBlock(ItemStack itemstack, Level world, BlockState block, BlockPos pos, LivingEntity entityliving) {
        return false;
    }

    @Override
    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        return false;
    }

    @Override
    public float getAttackDelay(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        return 0.0f;
    }

    @Override
    public float getKnockBack(ItemStack itemstack, LivingEntity entityliving, LivingEntity attacker) {
        return 0.0f;
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    @Override
    public void addItemAttributeModifiers(Multimap<Attribute, AttributeModifier> multimap) {
        multimap.put((Object)WeaponModAttributes.RELOAD_TIME, (Object)new AttributeModifier(IItemWeapon.RELOAD_TIME_MODIFIER, "Weapon reloadtime modifier", (double)this.rangedSpecs.getReloadTime(), AttributeModifier.Operation.ADDITION));
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemstack, Player player, Entity entity) {
        return false;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack itemstack) {
        ReloadHelper.ReloadState state = ReloadHelper.getReloadState(itemstack);
        if (state == ReloadHelper.ReloadState.STATE_NONE) {
            return UseAnim.BLOCK;
        }
        if (state == ReloadHelper.ReloadState.STATE_READY) {
            return UseAnim.BOW;
        }
        return UseAnim.NONE;
    }

    @Override
    public int getUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(ItemStack itemstack, Level world, Player entityplayer, InteractionHand hand) {
        if (itemstack.m_41619_() || entityplayer.m_6117_()) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        if (!this.hasAmmo(itemstack, world, entityplayer)) {
            this.soundEmpty(itemstack, world, entityplayer);
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        if (RangedComponent.isReadyToFire(itemstack)) {
            this.soundCharge(itemstack, world, entityplayer);
            entityplayer.m_6672_(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        entityplayer.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public void onUsingTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (ReloadHelper.getReloadState(stack) == ReloadHelper.ReloadState.STATE_NONE && this.getUseDuration(stack) - remainingUseDuration >= this.getReloadDuration(stack)) {
            this.effectReloadDone(stack, livingEntity.f_19853_, livingEntity);
            RangedComponent.setReloadState(stack, ReloadHelper.ReloadState.STATE_RELOADED);
        }
    }

    @Override
    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entityliving, int i) {
        if (!RangedComponent.isReloaded(itemstack)) {
            return;
        }
        if (RangedComponent.isReadyToFire(itemstack)) {
            if (this.hasAmmoAndConsume(itemstack, world, entityliving)) {
                this.fire(itemstack, world, entityliving, i);
            }
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_NONE);
        } else {
            RangedComponent.setReloadState(itemstack, ReloadHelper.ReloadState.STATE_READY);
        }
    }

    @Override
    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int i, boolean flag) {
    }

    public void soundEmpty(ItemStack itemstack, Level world, Player entityplayer) {
        world.m_6263_(null, entityplayer.m_20185_(), entityplayer.m_20186_(), entityplayer.m_20189_(), SoundEvents.f_11762_, SoundSource.PLAYERS, 1.0f, 1.25f);
    }

    public void soundCharge(ItemStack itemstack, Level world, Player entityplayer) {
    }

    public void postShootingEffects(ItemStack itemstack, LivingEntity entityLiving, Level world) {
        if (entityLiving instanceof Player) {
            Player entityplayer = (Player)entityLiving;
            this.effectPlayer(itemstack, entityplayer, world);
        }
        this.effectShoot(world, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), entityLiving.m_146908_(), entityLiving.m_146909_());
    }

    public abstract void effectReloadDone(ItemStack var1, Level var2, LivingEntity var3);

    public abstract void fire(ItemStack var1, Level var2, LivingEntity var3, int var4);

    public abstract void effectPlayer(ItemStack var1, Player var2, Level var3);

    public abstract void effectShoot(Level var1, double var2, double var4, double var6, float var8, float var9);

    public void applyProjectileEnchantments(EntityProjectile<?> entity, ItemStack itemstack) {
        int knockback;
        int damage;
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemstack) > 0) {
            entity.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
        }
        if ((damage = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)itemstack)) > 0) {
            entity.setExtraDamage(damage);
        }
        if ((knockback = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)itemstack)) > 0) {
            entity.m_36735_(knockback);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)itemstack) > 0) {
            entity.m_20254_(100);
        }
    }

    public int getReloadDuration(ItemStack itemstack) {
        return this.rangedSpecs.getReloadTime();
    }

    public List<Item> getAmmoItems() {
        return this.rangedSpecs.getAmmoItems();
    }

    protected ItemStack findAmmo(Player entityplayer) {
        Tuple<InteractionHand, Integer> slot = WMItem.findAnyItemSlot(entityplayer, this.getAmmoItems());
        if (slot == null) {
            return ItemStack.f_41583_;
        }
        NonNullList inv = slot.m_14418_() == InteractionHand.OFF_HAND ? entityplayer.m_150109_().f_35976_ : entityplayer.m_150109_().f_35974_;
        return (ItemStack)inv.get(((Integer)slot.m_14419_()).intValue());
    }

    protected boolean consumeAmmo(Player entityplayer) {
        return WMItem.consumeAnyInventoryItem(entityplayer, this.getAmmoItems());
    }

    public boolean hasAmmoAndConsume(ItemStack itemstack, Level world, LivingEntity entityliving) {
        if (!(entityliving instanceof Player)) {
            return true;
        }
        Player entityplayer = (Player)entityliving;
        return entityplayer.m_7500_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemstack) > 0 || this.consumeAmmo(entityplayer);
    }

    public boolean hasAmmo(ItemStack itemstack, Level world, Player entityplayer) {
        boolean flag = !this.findAmmo(entityplayer).m_41619_();
        return entityplayer.m_7500_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemstack) > 0 || flag;
    }

    public float getFOVMultiplier(int ticksinuse) {
        float f1 = (float)ticksinuse / this.getMaxAimTimeTicks();
        f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
        return 1.0f - f1 * this.getMaxZoom();
    }

    protected float getMaxAimTimeTicks() {
        return 20.0f;
    }

    protected float getMaxZoom() {
        return 0.15f;
    }

    public static enum RangedSpecs {
        BLOWGUN("blowgun", 250, (String[])Arrays.stream(DartType.dartTypes).filter(Objects::nonNull).map(t -> new ResourceLocation("weaponmod", t.typeName()).toString()).toArray(String[]::new)),
        CROSSBOW("crossbow", 250, new ResourceLocation("weaponmod", "bolt").toString()),
        MUSKET("musket", 80, new ResourceLocation("weaponmod", "bullet").toString()),
        BLUNDERBUSS("blunderbuss", 80, new ResourceLocation("weaponmod", "shot").toString()),
        FLINTLOCK("flintlock", 8, new ResourceLocation("weaponmod", "bullet").toString()),
        MORTAR("mortar", 40, new ResourceLocation("weaponmod", "shell").toString());

        private int reloadTime;
        private List<Item> ammoItems;
        private final String[] ammoItemTags;
        public final String reloadTimeTag;
        public final int durability;

        private RangedSpecs(String reloadtimetag, int durability, String ... ammoitemtags) {
            this.ammoItemTags = ammoitemtags;
            this.reloadTimeTag = reloadtimetag;
            this.durability = durability;
            this.ammoItems = null;
            this.reloadTime = -1;
        }

        public int getReloadTime() {
            if (this.reloadTime < 0) {
                this.reloadTime = WeaponModConfig.get().getReloadTime(this.reloadTimeTag);
                BalkonsWeaponMod.LOGGER.debug("Found reload time {} for {} @{}", (Object)this.reloadTime, (Object)this.reloadTimeTag, (Object)this);
            }
            return this.reloadTime;
        }

        public List<Item> getAmmoItems() {
            if (this.ammoItems == null) {
                this.ammoItems = Arrays.stream(this.ammoItemTags).map(t -> (Item)Registry.f_122827_.m_7745_(new ResourceLocation(t))).collect(Collectors.toList());
                BalkonsWeaponMod.LOGGER.debug("Found items {} for {} @{}", this.ammoItems, (Object)Arrays.toString(this.ammoItemTags), (Object)this);
            }
            return this.ammoItems;
        }
    }
}

