/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.network;

import ckathode.weaponmod.AdvancedExplosion;
import ckathode.weaponmod.network.WMMessage;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MsgExplosion
implements WMMessage<MsgExplosion> {
    private double x;
    private double y;
    private double z;
    private float size;
    private List<BlockPos> blocks;
    private boolean smallParticles;
    private boolean bigParticles;

    public MsgExplosion() {
    }

    public MsgExplosion(AdvancedExplosion explosion, boolean smallparts, boolean bigparts) {
        this.x = explosion.explosionX;
        this.y = explosion.explosionY;
        this.z = explosion.explosionZ;
        this.size = explosion.explosionSize;
        this.blocks = explosion.m_46081_();
        this.smallParticles = smallparts;
        this.bigParticles = bigparts;
    }

    @Override
    public void decode(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.size = buf.readFloat();
        this.smallParticles = buf.readBoolean();
        this.bigParticles = buf.readBoolean();
        int size = buf.readInt();
        this.blocks = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            int ix = buf.readByte() + (int)this.x;
            int iy = buf.readByte() + (int)this.y;
            int iz = buf.readByte() + (int)this.z;
            this.blocks.add(new BlockPos(ix, iy, iz));
        }
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.size);
        buf.writeBoolean(this.smallParticles);
        buf.writeBoolean(this.bigParticles);
        buf.writeInt(this.blocks.size());
        for (BlockPos pos : this.blocks) {
            int dx = pos.m_123341_() - (int)this.x;
            int dy = pos.m_123342_() - (int)this.y;
            int dz = pos.m_123343_() - (int)this.z;
            buf.writeByte(dx);
            buf.writeByte(dy);
            buf.writeByte(dz);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClientSide(MsgExplosion msg, Supplier<NetworkManager.PacketContext> ctx) {
        Level world = ctx.get().getPlayer().m_183503_();
        AdvancedExplosion expl = new AdvancedExplosion(world, null, this.x, this.y, this.z, this.size, false, Explosion.BlockInteraction.DESTROY);
        expl.setAffectedBlockPositions(this.blocks);
        expl.doParticleExplosion(this.smallParticles, this.bigParticles);
    }

    @Override
    public void handleServerSide(MsgExplosion msg, Supplier<NetworkManager.PacketContext> ctx) {
    }
}

