/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.network;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.WMUtil;
import ckathode.weaponmod.network.MsgCannonFire;
import ckathode.weaponmod.network.MsgExplosion;
import ckathode.weaponmod.network.WMMessage;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class WMMessagePipeline {
    public static final NetworkChannel CHANNEL = NetworkChannel.create((ResourceLocation)new ResourceLocation("weaponmod", "main"));
    private static final LinkedList<Class<? extends WMMessage<?>>> ID_TO_PACKET = new LinkedList();

    public static <T extends WMMessage<T>> void registerPacket(Class<T> messageType) {
        ID_TO_PACKET.add(messageType);
        CHANNEL.register(messageType, WMMessagePipeline::encode, WMMessagePipeline::decode, WMMessagePipeline::handle);
    }

    private static <T extends WMMessage<T>> void encode(T msg, FriendlyByteBuf buf) {
        if (!ID_TO_PACKET.contains(msg.getClass())) {
            throw new NullPointerException("No Packet Registered for: " + msg.getClass().getCanonicalName());
        }
        int discriminator = ID_TO_PACKET.indexOf(msg.getClass());
        buf.writeInt(discriminator);
        msg.encode((ByteBuf)buf);
    }

    private static <T extends WMMessage<T>> T decode(FriendlyByteBuf buf) {
        int discriminator;
        Class<WMMessage<?>> clazz;
        ByteBuf payload = buf.duplicate();
        if (payload.readableBytes() < 1) {
            BalkonsWeaponMod.LOGGER.error("Balkon's Weapon Mod has received an empty buffer, likely a result of a LAN server issue.");
        }
        if ((clazz = ID_TO_PACKET.get(discriminator = payload.readInt())) == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        try {
            WMMessage<?> pkt = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pkt.decode(payload.slice());
            return (T)pkt;
        }
        catch (Throwable t) {
            NullPointerException e = new NullPointerException("Could not instantiate packet: " + discriminator);
            e.addSuppressed(t);
            throw e;
        }
    }

    private static <T extends WMMessage<T>> void handle(T msg, Supplier<NetworkManager.PacketContext> ctx) {
        switch (WMUtil.EffectiveSide.get()) {
            case CLIENT: {
                msg.handleClientSide(msg, ctx);
                break;
            }
            case SERVER: {
                msg.handleServerSide(msg, ctx);
            }
        }
    }

    public static <T extends WMMessage<T>> void sendTo(@NotNull WMMessage<T> message, @NotNull ServerPlayer player) {
        if (CHANNEL.canPlayerReceive(player, message.getClass())) {
            CHANNEL.sendToPlayer(player, message);
        }
    }

    public static <T extends WMMessage<T>> void sendToAround(@NotNull WMMessage<T> message, @NotNull ServerLevel level, double x, double y, double z, double radius, ResourceKey<Level> dimension) {
        for (ServerPlayer player : level.m_142572_().m_6846_().m_11314_()) {
            double f;
            double e;
            double d;
            if (player.f_19853_.m_46472_() != dimension || !((d = x - player.m_20185_()) * d + (e = y - player.m_20186_()) * e + (f = z - player.m_20189_()) * f < radius * radius)) continue;
            WMMessagePipeline.sendTo(message, player);
        }
    }

    public static <T extends WMMessage<T>> void sendToServer(@NotNull WMMessage<T> message) {
        if (CHANNEL.canServerReceive(message.getClass())) {
            CHANNEL.sendToServer(message);
        }
    }

    public static void init() {
        WMMessagePipeline.registerPacket(MsgCannonFire.class);
        WMMessagePipeline.registerPacket(MsgExplosion.class);
    }
}

