/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiOverlayReloaded {
    public static void renderGUIOverlay(PoseStack matrixStack) {
        if (!WeaponModConfig.get().guiOverlayReloaded) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer p = mc.f_91074_;
        if (p == null) {
            return;
        }
        GuiOverlayReloaded.renderForHand(InteractionHand.MAIN_HAND, (Player)p, matrixStack);
        GuiOverlayReloaded.renderForHand(InteractionHand.OFF_HAND, (Player)p, matrixStack);
    }

    private static void renderForHand(InteractionHand hand, Player p, PoseStack matrixStack) {
        Item item;
        ItemStack is;
        Minecraft mc = Minecraft.m_91087_();
        int currentItem = p.m_150109_().f_35977_;
        IItemWeapon item2 = null;
        ItemStack itemStack = is = hand == InteractionHand.OFF_HAND ? p.m_21206_() : p.m_150109_().m_8020_(currentItem);
        if (!is.m_41619_() && (item = is.m_41720_()) instanceof IItemWeapon) {
            IItemWeapon iiw;
            item2 = iiw = (IItemWeapon)item;
        }
        if (item2 == null) {
            return;
        }
        RangedComponent rc = item2.getRangedComponent();
        MeleeComponent mec = item2.getMeleeComponent();
        boolean set = false;
        float f = 0.0f;
        int offset = 0;
        if (rc != null) {
            if (p.m_7655_() == hand) {
                if (RangedComponent.isReloaded(is)) {
                    f = 1.0f;
                    offset = RangedComponent.isReadyToFire(is) ? 48 : 24;
                } else {
                    f = Mth.m_14036_((float)((float)p.m_21252_() / (float)rc.getReloadDuration(is)), (float)0.0f, (float)1.0f);
                }
                set = true;
            }
        } else if (mec != null && mec.shouldRenderCooldown()) {
            f = Mth.m_14036_((float)mec.getCooldown(), (float)0.0f, (float)1.0f);
            set = true;
        }
        if (!set) {
            return;
        }
        HumanoidArm offHandSide = p.m_5737_().m_20828_();
        Window window = mc.m_91268_();
        int x0 = window.m_85445_() / 2 + (hand == InteractionHand.OFF_HAND ? (offHandSide == HumanoidArm.LEFT ? -120 : 91) : -92 + currentItem * 20);
        int y0 = window.m_85446_() + 1;
        int tx = hand == InteractionHand.OFF_HAND ? (offHandSide == HumanoidArm.LEFT ? 24 : 53) : 0;
        int width = hand == InteractionHand.OFF_HAND ? 29 : 24;
        int height = (int)(f * 24.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WeaponModResources.Gui.OVERLAY);
        GuiComponent.m_93143_((PoseStack)matrixStack, (int)x0, (int)(y0 - height), (int)-90, (float)tx, (float)(offset + 24 - height), (int)width, (int)height, (int)256, (int)256);
    }
}

