/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.render.ModelCannonBarrel;
import ckathode.weaponmod.render.ModelCannonLegacy;
import ckathode.weaponmod.render.ModelCannonStandard;
import ckathode.weaponmod.render.WMRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RenderCannon
extends WMRenderer<EntityCannon> {
    private final ModelCannonBarrel modelBarrel;
    private final ModelCannonStandard modelStandard;
    private final ModelCannonLegacy modelLegacy;

    public RenderCannon(EntityRendererProvider.Context context) {
        super(context);
        this.modelBarrel = new ModelCannonBarrel(context.m_174023_(ModelCannonBarrel.CANNON_BARREL_LAYER));
        this.modelStandard = new ModelCannonStandard(context.m_174023_(ModelCannonStandard.CANNON_STANDARD_LAYER));
        this.modelLegacy = new ModelCannonLegacy(context.m_174023_(ModelCannonLegacy.CANNON_LEGACY_LAYER));
        this.f_114477_ = 0.7f;
    }

    public void render(@NotNull EntityCannon entitycannon, float f, float f1, @NotNull PoseStack ms, @NotNull MultiBufferSource bufs, int lm) {
        ms.m_85836_();
        f = this.interpolateRotation(entitycannon.f_19859_, entitycannon.m_146908_(), f1);
        if (WeaponModConfig.get().legacyCannonModel) {
            ms.m_85837_(0.0, 0.1, 0.0);
            ms.m_85845_(Vector3f.f_122225_.m_122240_(-f));
        } else {
            ms.m_85837_(0.0, 2.375, 0.0);
            ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - f));
        }
        float f2 = (float)entitycannon.m_38385_() - f1;
        float f3 = (float)entitycannon.getCurrentDamage() - f1;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            ms.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14031_((float)f2) * f2 * f3 / 10.0f * (float)entitycannon.getRockDirection() / 5.0f));
        }
        VertexConsumer builder = bufs.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entitycannon)));
        float f4 = 1.0f;
        if (entitycannon.isSuperPowered() && entitycannon.f_19797_ % 5 < 2) {
            f4 = 1.5f;
        }
        if (WeaponModConfig.get().legacyCannonModel) {
            ms.m_85841_(-1.0f, -1.0f, 1.0f);
            ms.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            this.modelLegacy.barrel.f_104203_ = Math.max(-entitycannon.m_146909_() / 120.0f, -0.25f);
            this.modelLegacy.m_7695_(ms, builder, lm, OverlayTexture.f_118083_, entitycannon.m_6073_() * f4, entitycannon.m_6073_() * f4, entitycannon.m_6073_() * f4, 1.0f);
        } else {
            float yawRadians;
            float rot = entitycannon.f_19860_ + (entitycannon.m_146909_() - entitycannon.f_19860_) * f1;
            rot = Math.min(rot, 20.0f);
            ms.m_85841_(-1.6f, -1.6f, 1.6f);
            ms.m_85836_();
            ms.m_85837_(0.0, 1.0, 0.0);
            ms.m_85845_(Vector3f.f_122223_.m_122240_(rot));
            ms.m_85837_(0.0, -1.0, 0.0);
            this.modelBarrel.m_7695_(ms, builder, lm, OverlayTexture.f_118083_, entitycannon.m_6073_() * f4, entitycannon.m_6073_() * f4, entitycannon.m_6073_() * f4, 1.0f);
            ms.m_85849_();
            this.modelStandard.base1.f_104204_ = yawRadians = -((float)Math.toRadians(f));
            this.modelStandard.base2.f_104204_ = yawRadians;
            this.modelStandard.baseStand.f_104204_ = yawRadians;
            this.modelStandard.m_7695_(ms, builder, lm, OverlayTexture.f_118083_, entitycannon.m_6073_() * f4, entitycannon.m_6073_() * f4, entitycannon.m_6073_() * f4, 1.0f);
        }
        ms.m_85849_();
        super.m_7392_((Entity)entitycannon, f, f1, ms, bufs, lm);
    }

    private float interpolateRotation(float from, float to, float by) {
        return (from + Mth.m_14177_((float)(to - from)) * by) % 360.0f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityCannon entity) {
        return WeaponModConfig.get().legacyCannonModel ? WeaponModResources.Entity.CANNON_LEGACY : WeaponModResources.Entity.CANNON;
    }
}

