/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.entity.projectile.MaterialRegistry;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.ItemHitEffect;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMaterialProjectile<T extends EntityMaterialProjectile<T>>
extends EntityProjectile<T> {
    private static final class_2940<Integer> WEAPON_MATERIAL = class_2945.method_12791(EntityMaterialProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_1799> WEAPON_ITEM = class_2945.method_12791(EntityMaterialProjectile.class, (class_2941)class_2943.field_13322);
    private static final float[][] MATERIAL_COLORS = new float[][]{{0.6f, 0.4f, 0.1f}, {0.5f, 0.5f, 0.5f}, {1.0f, 1.0f, 1.0f}, {0.0f, 0.8f, 0.7f}, {1.0f, 0.9f, 0.0f}, {0.3f, 0.3f, 0.3f}, {0.9f, 0.5f, 0.3f}};

    public EntityMaterialProjectile(class_1299<T> type, class_1937 world) {
        super(type, world);
    }

    public EntityMaterialProjectile(class_1299<T> type, class_1937 world, @Nullable class_1799 firedFromWeapon) {
        super(type, world, firedFromWeapon);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(WEAPON_MATERIAL, (Object)0);
        builder.method_56912(WEAPON_ITEM, (Object)class_1799.field_8037);
    }

    @Override
    public void saveAdditionalSpawnData(class_2540 buf) {
        super.saveAdditionalSpawnData(buf);
        buf.method_53002(this.getWeaponMaterialId());
        class_1799.field_48349.encode((Object)new class_9129((ByteBuf)buf, this.method_56673()), (Object)this.getWeapon());
    }

    @Override
    public void loadAdditionalSpawnData(class_2540 buf) {
        super.loadAdditionalSpawnData(buf);
        this.field_6011.method_12778(WEAPON_MATERIAL, (Object)buf.readInt());
        this.field_6011.method_12778(WEAPON_ITEM, (Object)((class_1799)class_1799.field_48349.decode((Object)new class_9129((ByteBuf)buf, this.method_56673()))));
    }

    public float applyEnchantmentBonus(class_1297 entity, float baseDamage) {
        class_1937 class_19372;
        class_1297 shooter = this.method_24921();
        class_1799 weaponItem = this.method_59958();
        if (weaponItem != null && shooter instanceof class_1309 && entity instanceof class_1309 && (class_19372 = this.method_73183()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            baseDamage = class_1890.method_60120((class_3218)serverLevel, (class_1799)weaponItem, (class_1297)entity, (class_1282)this.getDamageSource(), (float)baseDamage);
        }
        return baseDamage;
    }

    @Override
    public void method_7454(class_3966 result) {
        class_1792 class_17922;
        super.method_7454(result);
        class_1799 thrownItem = this.getWeapon();
        if (!thrownItem.method_7960() && (class_17922 = thrownItem.method_7909()) instanceof ItemHitEffect) {
            ItemHitEffect ihe = (ItemHitEffect)class_17922;
            ihe.onHitEntity(this, result);
        }
    }

    @Override
    public void method_24920(class_3965 result) {
        class_1792 class_17922;
        super.method_24920(result);
        class_1799 thrownItem = this.getWeapon();
        if (!thrownItem.method_7960() && (class_17922 = thrownItem.method_7909()) instanceof ItemHitEffect) {
            ItemHitEffect ihe = (ItemHitEffect)class_17922;
            ihe.onHitBlock(this, result);
        }
    }

    @Override
    public void applyEntityHitEffects(class_1297 entity) {
        class_6880 fireAspect;
        int i;
        super.applyEntityHitEffects(entity);
        class_1799 stack = this.getWeapon();
        class_2378 enchRegistry = this.method_56673().method_30530(class_7924.field_41265);
        if (entity instanceof class_1309) {
            int i2;
            class_1309 livingEntity = (class_1309)entity;
            class_6880 knockBack = enchRegistry.method_46746(class_1893.field_9121).orElse(null);
            int n = i2 = knockBack == null ? 0 : class_1890.method_8225((class_6880)knockBack, (class_1799)stack);
            if (i2 != 0) {
                livingEntity.method_6005((double)((float)i2 * 0.4f), (double)(-class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
            }
        }
        int n = i = (fireAspect = (class_6880)enchRegistry.method_46746(class_1893.field_9124).orElse(null)) == null ? 0 : class_1890.method_8225((class_6880)fireAspect, (class_1799)stack);
        if (i > 0 || this.method_5809()) {
            entity.method_5639(i > 0 ? (float)i : 1.0f);
        }
    }

    public void setThrownItemStack(@NotNull class_1799 itemstack) {
        this.field_6011.method_12778(WEAPON_ITEM, (Object)itemstack);
        this.updateWeaponMaterial();
    }

    @Override
    @NotNull
    public class_1799 method_7445() {
        return this.getWeapon();
    }

    public int getWeaponMaterialId() {
        return (Integer)this.field_6011.method_12789(WEAPON_MATERIAL);
    }

    @NotNull
    public class_1799 getWeapon() {
        return (class_1799)this.field_6011.method_12789(WEAPON_ITEM);
    }

    protected void updateWeaponMaterial() {
        IItemWeapon weapon;
        class_1792 class_17922;
        class_1799 thrownItem = this.getWeapon();
        if (!thrownItem.method_7960() && (class_17922 = thrownItem.method_7909()) instanceof IItemWeapon && (weapon = (IItemWeapon)class_17922).getMeleeComponent() != null) {
            int material = MaterialRegistry.getMaterialID(thrownItem);
            if (material < 0) {
                material = MaterialRegistry.getOrdinal(weapon.getMeleeComponent().weaponMaterial);
            }
            this.field_6011.method_12778(WEAPON_MATERIAL, (Object)material);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public float[] getMaterialColor() {
        int id = this.getWeaponMaterialId();
        if (id >= 0 && id < MATERIAL_COLORS.length) {
            return MATERIAL_COLORS[id];
        }
        return MaterialRegistry.getColorFromMaterialID(id);
    }

    @Override
    protected void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        class_1799 thrownItem = this.getWeapon();
        valueOutput.method_71468("thrI", class_1799.field_24671, (Object)thrownItem);
    }

    @Override
    protected void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.setThrownItemStack(valueInput.method_71426("thrI", class_1799.field_24671).orElse(class_1799.field_8037));
    }
}

