/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.AbstractWeaponComponent;
import ckathode.weaponmod.item.IExtendedReachItem;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9886;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeleeComponent
extends AbstractWeaponComponent {
    public final MeleeSpecs meleeSpecs;
    public final class_9886 weaponMaterial;

    public MeleeComponent(MeleeSpecs meleespecs, class_9886 itemTier) {
        this.meleeSpecs = meleespecs;
        this.weaponMaterial = itemTier;
    }

    @NotNull
    public class_9886 getWeaponMaterial() {
        return this.weaponMaterial == null ? class_9886.field_52585 : this.weaponMaterial;
    }

    @Override
    protected void onSetItem() {
    }

    @NotNull
    public class_9424 getToolComponent() {
        class_7871 holderGetter = class_7923.method_62715((class_2378)class_7923.field_41175);
        return new class_9424(List.of(class_9424.class_9425.method_58431((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{class_2246.field_10343.method_40142()}), (float)(this.meleeSpecs.blockDamage * 10.0f)), class_9424.class_9425.method_58434((class_6885)holderGetter.method_46735(class_3481.field_44469), (float)this.meleeSpecs.blockDamage)), 1.0f, 2, false);
    }

    @Override
    public class_9285.class_9286 setAttributes(class_9285.class_9286 attributeBuilder) {
        MeleeComponent meleeComponent;
        float dmg = this.getEntityDamage();
        if (dmg > 0.0f || this.meleeSpecs.damageMult > 0.0f) {
            attributeBuilder = attributeBuilder.method_57487(class_5134.field_23721, new class_1322(class_1792.field_8006, (double)dmg, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(class_1792.field_8001, (double)(-this.meleeSpecs.attackDelay), class_1322.class_1323.field_6328), class_9274.field_49217);
        }
        if (this.meleeSpecs.getKnockBack(this.weaponMaterial) != 0.4f) {
            attributeBuilder = attributeBuilder.method_57487(WMRegistries.WEAPON_KNOCKBACK, new class_1322(WeaponModAttributes.WEAPON_KNOCKBACK_ID, (double)(this.meleeSpecs.getKnockBack(this.weaponMaterial) - 0.4f), class_1322.class_1323.field_6328), class_9274.field_49217);
        }
        if ((meleeComponent = this) instanceof IExtendedReachItem) {
            IExtendedReachItem ieri = (IExtendedReachItem)((Object)meleeComponent);
            try {
                attributeBuilder = attributeBuilder.method_57487(WMRegistries.WEAPON_REACH, new class_1322(WeaponModAttributes.WEAPON_REACH_ID, (double)(ieri.getExtendedReach(null, null, null) - 3.0f), class_1322.class_1323.field_6328), class_9274.field_49217);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return attributeBuilder;
    }

    @Override
    public class_1792.class_1793 setProperties(class_1792.class_1793 properties) {
        return properties.method_57349(class_9334.field_50077, (Object)this.getToolComponent()).method_7895(this.weaponMaterial == null ? this.meleeSpecs.durabilityBase : (int)((float)this.meleeSpecs.durabilityBase + (float)this.weaponMaterial.comp_2931() * this.meleeSpecs.durabilityMult));
    }

    @Override
    public float getDamage() {
        if (this.weaponMaterial == null) {
            return 0.0f;
        }
        return this.weaponMaterial.comp_2933() * this.meleeSpecs.damageMult;
    }

    @Override
    public float getEntityDamage() {
        return this.meleeSpecs.damageBase + this.getDamage();
    }

    @Override
    public boolean mineBlock(class_1799 itemstack, class_1937 world, class_2680 block, class_2338 pos, class_1309 entityliving) {
        if (block.method_26214((class_1922)world, pos) != 0.0f) {
            itemstack.method_7970(this.meleeSpecs.dmgFromBlock, entityliving, class_1304.field_6173);
        }
        return true;
    }

    @Override
    public void hurtEnemy(@NotNull class_1799 itemstack, @NotNull class_1309 entityliving, @NotNull class_1309 attacker) {
        int n = entityliving.field_6008;
        Objects.requireNonNull(entityliving);
        if (n == 20) {
            float kb = this.getKnockBack(itemstack, entityliving, attacker);
            PhysHelper.knockBack(entityliving, attacker, kb);
            if (this.meleeSpecs.attackDelay >= 3.0f) {
                entityliving.field_6008 += (int)this.getAttackDelay(itemstack, entityliving, attacker);
            } else {
                float f = this.meleeSpecs.attackDelay < 1.0f ? 1.2f : 2.0f;
                entityliving.field_6008 -= (int)(f / this.getAttackDelay(itemstack, entityliving, attacker));
            }
        }
        itemstack.method_7970(this.meleeSpecs.dmgFromEntity, attacker, class_1304.field_6173);
    }

    @Override
    public float getAttackDelay(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        return this.meleeSpecs.attackDelay;
    }

    @Override
    public float getKnockBack(class_1799 itemstack, class_1309 entityliving, class_1309 attacker) {
        return this.meleeSpecs.getKnockBack(this.weaponMaterial);
    }

    @Override
    public int getEnchantmentValue() {
        return this.weaponMaterial == null ? 1 : this.weaponMaterial.comp_2934();
    }

    @Override
    public boolean onLeftClickEntity(class_1799 itemstack, class_1657 player, class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            PhysHelper.prepareKnockbackOnEntity((class_1309)player, livingEntity);
        }
        return false;
    }

    @Override
    @NotNull
    public class_1839 getUseAnimation(class_1799 itemstack) {
        return class_1839.field_8949;
    }

    @Override
    public int getUseDuration(class_1799 itemstack) {
        return 72000;
    }

    @Override
    @NotNull
    public class_1269 use(class_1799 itemstack, class_1937 world, class_1657 entityplayer, class_1268 hand) {
        if (this.getUseAnimation(itemstack) != class_1839.field_8952) {
            entityplayer.method_6019(hand);
        }
        return class_1269.field_5811;
    }

    @Override
    public void onUsingTick(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
    }

    @Override
    public boolean releaseUsing(class_1799 itemstack, class_1937 world, class_1309 entityliving, int i) {
        return false;
    }

    @Override
    public void inventoryTick(@NotNull class_1799 itemStack, @NotNull class_3218 serverLevel, @NotNull class_1297 entity, @Nullable class_1304 equipmentSlot) {
    }

    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderCooldown() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public float getCooldown() {
        return 0.0f;
    }

    public static void applyProjectileEnchantments(EntityProjectile<?> entity, class_1799 itemstack) {
        class_2378 enchRegistry = entity.method_56673().method_30530(class_7924.field_41265);
        class_6880 fireAspect = enchRegistry.method_46746(class_1893.field_9124).orElse(null);
        if (fireAspect != null && class_1890.method_8225((class_6880)fireAspect, (class_1799)itemstack) > 0) {
            entity.method_5639(100.0f);
        }
    }

    public static enum MeleeSpecs {
        SPEAR(0, 1.0f, 3.0f, 1.0f, 1.0f, 0.2f, 1, 2, 2.7f),
        HALBERD(0, 1.0f, 4.0f, 1.0f, 1.5f, 0.6f, 1, 2, 3.2f),
        BATTLEAXE(0, 1.0f, 3.0f, 1.0f, 1.5f, 0.5f, 1, 2, 3.0f),
        WARHAMMER(0, 1.0f, 4.0f, 1.0f, 1.0f, 0.7f, 1, 2, 3.0f),
        KNIFE(0, 0.5f, 3.0f, 1.0f, 1.5f, 0.2f, 1, 2, 2.0f),
        KATANA(0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1, 2, 0.2f),
        FIREROD(1, 0.0f, 1.0f, 0.0f, 1.0f, 0.4f, 2, 0, 0.0f),
        BOOMERANG(0, 0.5f, 2.0f, 1.0f, 1.0f, 0.4f, 1, 1, 2.0f),
        NONE(0, 1.0f, 1.0f, 0.0f, 1.0f, 0.4f, 0, 0, 0.0f);

        public final int durabilityBase;
        public final float durabilityMult;
        public final float damageBase;
        public final float damageMult;
        public final float blockDamage;
        public final float knockback;
        public final float attackDelay;
        public final int dmgFromEntity;
        public final int dmgFromBlock;

        private MeleeSpecs(int durbase, float durmult, float dmgbase, float dmgmult, float blockdmg, float knockbck, int dmgfromentity, int dmgfromblock, float attackdelay) {
            this.durabilityBase = durbase;
            this.durabilityMult = durmult;
            this.damageBase = dmgbase;
            this.damageMult = dmgmult;
            this.blockDamage = blockdmg;
            this.knockback = knockbck;
            this.dmgFromEntity = dmgfromentity;
            this.dmgFromBlock = dmgfromblock;
            this.attackDelay = attackdelay;
        }

        public float getKnockBack(class_9886 material) {
            return material == class_9886.field_52589 ? this.knockback * 1.5f : this.knockback;
        }
    }
}

