/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.IItemWeapon;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityBoomerang
extends EntityMaterialProjectile {
    public static final String NAME = "boomerang";
    private static final int BOOMERANG = 20;
    public static final double RETURN_STRENGTH = 0.05;
    public static final float MIN_FLOAT_STRENGTH = 0.4f;
    private float soundTimer;
    public float floatStrength;

    public EntityBoomerang(World world) {
        super(world);
    }

    public EntityBoomerang(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityBoomerang(World world, EntityLivingBase shooter, ItemStack itemstack) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        this.setThrower((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
        this.soundTimer = 0.0f;
    }

    @Override
    public void setAim(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, f3, f4);
        this.field_70159_w += entity.field_70159_w;
        this.field_70179_y += entity.field_70179_y;
        if (!entity.field_70122_E) {
            this.field_70181_x += entity.field_70181_x;
        }
        this.floatStrength = Math.min(1.5f, f3);
        this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(this.floatStrength));
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void func_70071_h_() {
        Entity shooter;
        super.func_70071_h_();
        this.floatStrength = this.field_70180_af.func_111145_d(20);
        if (this.inGround) {
            return;
        }
        this.floatStrength *= 0.994f;
        if (this.floatStrength < 0.4f) {
            if (this.func_70241_g()) {
                this.func_70243_d(false);
            }
            this.floatStrength = 0.0f;
        }
        float limitedStrength = Math.min(1.0f, this.floatStrength);
        if (!this.beenInGround) {
            this.field_70177_z += 20.0f * this.floatStrength;
        }
        if (!this.beenInGround && (shooter = this.getThrower()) != null && this.floatStrength > 0.0f) {
            double dx = this.field_70165_t - shooter.field_70165_t;
            double dy = this.field_70163_u - shooter.field_70163_u - (double)shooter.func_70047_e();
            double dz = this.field_70161_v - shooter.field_70161_v;
            double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.field_70159_w -= 0.05 * (dx /= d);
            this.field_70181_x -= 0.05 * (dy /= d);
            this.field_70179_y -= 0.05 * (dz /= d);
            this.soundTimer += limitedStrength;
            if (this.soundTimer > 3.0f) {
                this.field_70170_p.func_72956_a((Entity)this, "random.bow", 0.6f, 1.0f / (this.field_70146_Z.nextFloat() * 0.2f + 2.2f - limitedStrength));
                this.soundTimer %= 3.0f;
            }
        }
        this.field_70180_af.func_75692_b(20, (Object)Float.valueOf(this.floatStrength));
    }

    @Override
    public void onHitEntity(MovingObjectPosition mop) {
        if (this.field_70170_p.field_72995_K || this.floatStrength < 0.4f) {
            return;
        }
        Entity entity = mop.field_72308_g;
        Entity shooter = this.getThrower();
        if (entity == shooter) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                ItemStack item = this.getPickupItem();
                if (item == null) {
                    return;
                }
                if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70441_a(item)) {
                    this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    this.onItemPickup(player);
                    this.func_70106_y();
                }
            }
            return;
        }
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        ItemStack thrownItem = this.getWeapon();
        if (thrownItem == null) {
            return;
        }
        float damage = ((IItemWeapon)thrownItem.func_77973_b()).getMeleeComponent().getEntityDamage() + 2.0f + this.extraDamage;
        damage += this.getMeleeHitDamage(entity);
        if (this.func_70241_g()) {
            damage += 2.0f;
        }
        if (entity.func_70097_a(damagesource, damage)) {
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            if (thrownItem.func_77952_i() + 1 >= thrownItem.func_77958_k()) {
                thrownItem.func_77979_a(1);
                if (thrownItem.field_77994_a <= 0) {
                    this.setThrownItemStack(null);
                }
                this.func_70106_y();
            } else {
                thrownItem.func_96631_a(1, this.field_70146_Z);
                if (thrownItem.field_77994_a <= 0) {
                    this.setThrownItemStack(null);
                }
                this.func_70016_h(0.0, 0.0, 0.0);
            }
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void onHitBlock(MovingObjectPosition raytraceResult) {
        BlockPos blockpos = raytraceResult.func_178782_a();
        this.xTile = blockpos.func_177958_n();
        this.yTile = blockpos.func_177956_o();
        this.zTile = blockpos.func_177952_p();
        IBlockState iBlockState = this.field_70170_p.func_180495_p(blockpos);
        this.inTile = iBlockState.func_177230_c();
        this.inData = this.inTile.func_176201_c(iBlockState);
        this.field_70159_w = raytraceResult.field_72307_f.field_72450_a - this.field_70165_t;
        this.field_70181_x = raytraceResult.field_72307_f.field_72448_b - this.field_70163_u;
        this.field_70179_y = raytraceResult.field_72307_f.field_72449_c - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.field_70159_w *= (double)(-this.field_70146_Z.nextFloat() * 0.5f);
        this.field_70179_y *= (double)(-this.field_70146_Z.nextFloat() * 0.5f);
        this.field_70181_x = this.field_70146_Z.nextFloat() * 0.1f;
        this.inGround = raytraceResult.field_178784_b == EnumFacing.UP;
        this.func_70243_d(false);
        this.beenInGround = true;
        this.floatStrength = 0.0f;
        if (this.inTile.func_149688_o() != Material.field_151579_a) {
            this.inTile.func_180634_a(this.field_70170_p, blockpos, iBlockState, (Entity)this);
        }
    }

    @Override
    public void playHitSound() {
        this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.9f));
    }

    @Override
    public boolean aimRotation() {
        return this.beenInGround || this.floatStrength < 0.4f;
    }

    @Override
    public int getMaxLifetime() {
        return this.pickupStatus == EntityProjectile.PickupStatus.ALLOWED || this.pickupStatus == EntityProjectile.PickupStatus.OWNER_ONLY ? 0 : 1200;
    }

    @Override
    public boolean canBeCritical() {
        return true;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public float getGravity() {
        return this.beenInGround || this.floatStrength < 0.4f ? 0.05f : 0.0f;
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public void func_70100_b_(@Nonnull EntityPlayer entityplayer) {
        if (!this.beenInGround && this.ticksInAir > 5 && !this.field_70170_p.field_72995_K && this.floatStrength >= 0.4f && entityplayer == this.field_70250_c) {
            ItemStack item = this.getPickupItem();
            if (item == null) {
                return;
            }
            if (entityplayer.field_71075_bZ.field_75098_d || entityplayer.field_71071_by.func_70441_a(item)) {
                this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.func_70106_y();
                return;
            }
        }
        super.func_70100_b_(entityplayer);
    }
}

