/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.PhysHelper;
import ckathode.weaponmod.WeaponDamageSource;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityMortarShell
extends EntityProjectile {
    public static final String NAME = "shell";
    public float explosiveSize = 2.0f;

    public EntityMortarShell(World world) {
        super(world);
    }

    public EntityMortarShell(World world, double d, double d1, double d2) {
        this(world);
        this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        this.func_70107_b(d, d1, d2);
    }

    public EntityMortarShell(World world, EntityLivingBase shooter) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        this.setThrower((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
    }

    @Override
    public void setAim(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, f3, f4);
        this.field_70159_w += entity.field_70159_w;
        this.field_70179_y += entity.field_70179_y;
        if (!entity.field_70122_E) {
            this.field_70181_x += entity.field_70181_x;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        double speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        double amount = 8.0;
        if (speed > 1.0) {
            int i1 = 1;
            while ((double)i1 < amount) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + this.field_70159_w * (double)i1 / amount, this.field_70163_u + this.field_70181_x * (double)i1 / amount, this.field_70161_v + this.field_70179_y * (double)i1 / amount, 0.0, 0.0, 0.0, new int[0]);
                ++i1;
            }
        }
    }

    public void createCrater() {
        if (this.field_70170_p.field_72995_K || !this.inGround || this.func_70090_H()) {
            return;
        }
        this.func_70106_y();
        Entity shooter = this.getThrower();
        if (!(shooter instanceof EntityLivingBase)) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)((EntityLivingBase)shooter).func_70694_bm()) > 0) {
            float f1 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)((EntityLivingBase)shooter).func_70694_bm());
            this.explosiveSize += f1 / 4.0f;
        }
        boolean flag = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)((EntityLivingBase)shooter).func_70694_bm()) > 0;
        PhysHelper.createAdvancedExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosiveSize, BalkonsWeaponMod.instance.modConfig.mortarDoesBlockDamage, true, flag, false);
    }

    @Override
    public void onHitEntity(MovingObjectPosition mop) {
        this.field_70159_w -= this.field_70159_w / 2.0;
        this.field_70179_y -= this.field_70179_y / 2.0;
        this.field_70181_x -= this.field_70181_x / 2.0;
        DamageSource damagesource = WeaponDamageSource.causeProjectileWeaponDamage(this, this.getDamagingEntity());
        if (mop.field_72308_g.func_70097_a(damagesource, 5.0f)) {
            this.field_70170_p.func_72956_a((Entity)this, "damage.hurtflesh", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.4f + 0.7f));
        }
    }

    @Override
    public void onHitBlock(MovingObjectPosition raytraceResult) {
        BlockPos blockpos = raytraceResult.func_178782_a();
        this.xTile = blockpos.func_177958_n();
        this.yTile = blockpos.func_177956_o();
        this.zTile = blockpos.func_177952_p();
        IBlockState iBlockState = this.field_70170_p.func_180495_p(blockpos);
        this.inTile = iBlockState.func_177230_c();
        this.inData = this.inTile.func_176201_c(iBlockState);
        this.field_70159_w = raytraceResult.field_72307_f.field_72450_a - this.field_70165_t;
        this.field_70181_x = raytraceResult.field_72307_f.field_72448_b - this.field_70163_u;
        this.field_70179_y = raytraceResult.field_72307_f.field_72449_c - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.inGround = true;
        if (this.inTile.func_149688_o() != Material.field_151579_a) {
            this.inTile.func_180634_a(this.field_70170_p, blockpos, iBlockState, (Entity)this);
        }
        this.createCrater();
    }

    @Override
    public float getAirResistance() {
        return 0.98f;
    }

    @Override
    public float getGravity() {
        return 0.04f;
    }

    @Override
    @Nonnull
    public ItemStack getPickupItem() {
        return new ItemStack((Item)BalkonsWeaponMod.mortarShell, 1);
    }
}

