/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WMItemVariants;
import ckathode.weaponmod.entity.projectile.EntityFlail;
import ckathode.weaponmod.item.ItemMelee;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.WMItem;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlail
extends ItemMelee {
    private final float flailDamage;
    private final ModelResourceLocation thrownModel;
    private Boolean thrownModelExists;

    public ItemFlail(String id, MeleeComponent meleecomponent) {
        this("weaponmod", id, meleecomponent);
    }

    public ItemFlail(String modId, String id, MeleeComponent meleecomponent) {
        super(modId, id, meleecomponent);
        this.flailDamage = 4.0f + meleecomponent.weaponMaterial.func_78000_c();
        this.thrownModel = new ModelResourceLocation(new ResourceLocation(modId, this.rawId + "-thrown"), "inventory");
        this.thrownModelExists = null;
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Override
    public void func_77663_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull Entity entity, int i, boolean flag) {
        Entity entity2;
        int id;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!this.isThrown(player)) {
            return;
        }
        ItemStack itemstack2 = player.func_71045_bC();
        if (itemstack2 == null || !(itemstack2.func_77973_b() instanceof ItemFlail)) {
            this.setThrown(player, false);
        } else if (itemstack2.func_77973_b() == this && (id = PlayerWeaponData.getFlailEntityId(player)) != 0 && (entity2 = world.func_73045_a(id)) instanceof EntityFlail) {
            ((EntityFlail)entity2).setThrower((Entity)player);
            ((EntityFlail)entity2).setThrownItemStack(itemstack);
        }
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        this.removePreviousFlail(world, entityplayer);
        if (itemstack.field_77994_a > 0) {
            entityplayer.func_71038_i();
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
                if (itemstack.field_77994_a <= 0) {
                    WMItem.deleteStack((IInventory)entityplayer.field_71071_by, itemstack);
                }
            }
            if (itemstack.field_77994_a > 0) {
                this.throwFlail(itemstack, world, entityplayer);
            } else {
                WMItem.deleteStack((IInventory)entityplayer.field_71071_by, itemstack);
            }
        } else {
            WMItem.deleteStack((IInventory)entityplayer.field_71071_by, itemstack);
        }
        return itemstack;
    }

    @Override
    public boolean func_77644_a(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase entityliving, @Nonnull EntityLivingBase attacker) {
        this.func_77659_a(itemstack, attacker.field_70170_p, (EntityPlayer)attacker);
        return true;
    }

    public void throwFlail(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        world.func_72956_a((Entity)entityplayer, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!world.field_72995_K) {
            EntityFlail entityflail = new EntityFlail(world, (EntityLivingBase)entityplayer, itemstack);
            entityflail.setAim((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, 0.75f, 3.0f);
            PlayerWeaponData.setFlailEntityId(entityplayer, entityflail.func_145782_y());
            world.func_72838_d((Entity)entityflail);
            this.setThrown(entityplayer, true);
        }
    }

    public void setThrown(EntityPlayer entityplayer, boolean flag) {
        PlayerWeaponData.setFlailThrown(entityplayer, flag);
    }

    public boolean isThrown(EntityPlayer entityplayer) {
        return PlayerWeaponData.isFlailThrown(entityplayer);
    }

    private void removePreviousFlail(World world, EntityPlayer entityplayer) {
        Entity entity;
        int id = PlayerWeaponData.getFlailEntityId(entityplayer);
        if (id != 0 && (entity = world.func_73045_a(id)) instanceof EntityFlail) {
            entity.func_70106_y();
        }
    }

    public float getFlailDamage() {
        return this.flailDamage;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        if (this.thrownModelExists == null) {
            this.thrownModelExists = WMItemVariants.itemVariantExists(this.thrownModel);
        }
        if (this.thrownModelExists.booleanValue() && this.isThrown(player)) {
            return this.thrownModel;
        }
        return super.getModel(stack, player, useRemaining);
    }
}

