/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.WMItemVariants;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeCompHalberd;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemMelee
extends ItemSword
implements IItemWeapon {
    public final MeleeComponent meleeComponent;
    public final String rawId;
    private final ModelResourceLocation halberdStateModel;
    private Boolean halberdStateModelExists;

    public ItemMelee(String id, MeleeComponent meleecomponent) {
        this("weaponmod", id, meleecomponent);
    }

    public ItemMelee(String modId, String id, MeleeComponent meleecomponent) {
        super(meleecomponent.weaponMaterial == null ? Item.ToolMaterial.WOOD : meleecomponent.weaponMaterial);
        this.rawId = id;
        this.setRegistryName(new ResourceLocation(modId, id));
        this.func_77655_b(id);
        this.meleeComponent = meleecomponent;
        this.meleeComponent.setItem(this);
        meleecomponent.setThisItemProperties();
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.halberdStateModel = new ModelResourceLocation(new ResourceLocation(modId, this.rawId + "_state"), "inventory");
        this.halberdStateModelExists = null;
    }

    public float func_150931_i() {
        return this.meleeComponent.getEntityDamageMaterialPart();
    }

    public float func_150893_a(ItemStack itemstack, Block block) {
        return this.meleeComponent.getBlockDamage(itemstack, block);
    }

    public boolean func_150897_b(Block block) {
        return this.meleeComponent.canHarvestBlock(block);
    }

    public boolean func_77644_a(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase entityliving, @Nonnull EntityLivingBase attacker) {
        return this.meleeComponent.hitEntity(itemstack, entityliving, attacker);
    }

    public boolean func_179218_a(ItemStack itemstack, World world, Block block, BlockPos pos, EntityLivingBase entityliving) {
        return this.meleeComponent.onBlockDestroyed(itemstack, world, block, pos, entityliving);
    }

    public int func_77619_b() {
        return this.meleeComponent.getItemEnchantability();
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack itemstack) {
        return this.meleeComponent.getItemUseAction(itemstack);
    }

    public int func_77626_a(@Nonnull ItemStack itemstack) {
        return this.meleeComponent.getMaxItemUseDuration(itemstack);
    }

    @Override
    public boolean onLeftClickEntity(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull Entity entity) {
        return this.meleeComponent.onLeftClickEntity(itemstack, player, entity);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer entityplayer) {
        return this.meleeComponent.onItemRightClick(world, entityplayer, stack);
    }

    public void onUsingTick(ItemStack itemstack, EntityPlayer entityplayer, int count) {
        this.meleeComponent.onUsingTick(itemstack, (EntityLivingBase)entityplayer, count);
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        this.meleeComponent.onPlayerStoppedUsing(itemstack, world, (EntityLivingBase)entityplayer, i);
    }

    public void func_77663_a(@Nonnull ItemStack itemstack, @Nonnull World world, @Nonnull Entity entity, int i, boolean flag) {
        this.meleeComponent.onUpdate(itemstack, world, entity, i, flag);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        this.meleeComponent.addItemAttributeModifiers((Multimap<String, AttributeModifier>)multimap);
        return multimap;
    }

    @Override
    public Random getItemRand() {
        return field_77697_d;
    }

    @Override
    public MeleeComponent getMeleeComponent() {
        return this.meleeComponent;
    }

    @Override
    public RangedComponent getRangedComponent() {
        return null;
    }

    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        if (this.halberdStateModelExists == null) {
            this.halberdStateModelExists = WMItemVariants.itemVariantExists(this.halberdStateModel);
        }
        if (this.halberdStateModelExists.booleanValue() && MeleeCompHalberd.getHalberdState(stack)) {
            return this.halberdStateModel;
        }
        return super.getModel(stack, player, useRemaining);
    }
}

