/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.AdvancedExplosion;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WarhammerExplosion
extends AdvancedExplosion {
    public WarhammerExplosion(ServerLevel level, Entity entity, Vec3 center, float f, boolean flame, Explosion.BlockInteraction mode) {
        super(level, entity, center, f, flame, mode);
    }

    @Override
    public void doEntityExplosion(DamageSource damagesource) {
        float size = this.explosionSize * 2.0f;
        int k1 = Mth.floor((double)(this.center.x - (double)size - 1.0));
        int l1 = Mth.floor((double)(this.center.x + (double)size + 1.0));
        int i2 = Mth.floor((double)(this.center.y - (double)size - 1.0));
        int i3 = Mth.floor((double)(this.center.y + (double)size + 1.0));
        int j2 = Mth.floor((double)(this.center.z - (double)size - 1.0));
        int j3 = Mth.floor((double)(this.center.z + (double)size + 1.0));
        List list = this.serverLevel.getEntities(this.exploder, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i3, (double)j3));
        for (Entity entity : list) {
            double dr = Math.sqrt(entity.distanceToSqr(this.center)) / (double)size;
            if (!(dr <= 1.0)) continue;
            double dx = entity.getX() - this.center.x;
            double dy = entity.getEyeY() - this.center.y;
            double dz = entity.getZ() - this.center.z;
            double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double var36 = 1.0 - dr;
            int damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)size + 1.0);
            entity.hurt(damagesource, (float)damage);
            entity.setDeltaMovement(entity.getDeltaMovement().add(new Vec3((dx /= d) * var36, (dy /= d) * var36, (dz /= d) * var36)));
        }
    }
}

