/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity;

import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.entity.projectile.EntityCannonBall;
import ckathode.weaponmod.item.WMItem;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityCannon
extends Boat {
    public static final String ID = "cannon";
    public static final EntityType<EntityCannon> TYPE = WMRegistries.createEntityType("cannon", EntityDimensions.fixed((float)1.5f, (float)1.0f).withEyeHeight(0.0f), EntityCannon::new);
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.defineId(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> ROCK_DIRECTION = SynchedEntityData.defineId(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> CURRENT_DAMAGE = SynchedEntityData.defineId(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> LOADED = SynchedEntityData.defineId(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> LOAD_TIMER = SynchedEntityData.defineId(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> SUPER_POWERED = SynchedEntityData.defineId(EntityCannon.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public EntityCannon(EntityType<EntityCannon> entityType, Level world) {
        super(entityType, world, () -> WMRegistries.ITEM_CANNON.get());
        this.blocksBuilding = true;
        this.setXRot(-20.0f);
        this.setYRot(-180.0f);
        this.setRot(this.getYRot(), this.getXRot());
    }

    public EntityCannon(Level world, double d, double d1, double d2) {
        this(TYPE, world);
        this.setPos(d, d1, d2);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = d;
        this.yo = d1;
        this.zo = d2;
    }

    @NotNull
    public EntityType<?> getType() {
        return TYPE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TIME_SINCE_HIT, (Object)0);
        builder.define(ROCK_DIRECTION, (Object)1);
        builder.define(CURRENT_DAMAGE, (Object)0);
        builder.define(LOADED, (Object)0);
        builder.define(LOAD_TIMER, (Object)0);
        builder.define(SUPER_POWERED, (Object)0);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public boolean isPushable() {
        return false;
    }

    protected int getMaxPassengers() {
        return 1;
    }

    public boolean hurtServer(ServerLevel serverLevel, @NotNull DamageSource damagesource, float damage) {
        Player player;
        Entity entity;
        if (!this.isAlive()) {
            return true;
        }
        if (!damagesource.isDirect() && damagesource.getEntity() != null) {
            if (this.hasPassenger(damagesource.getEntity())) {
                return true;
            }
        } else if (damagesource.is(DamageTypes.PLAYER_ATTACK) && (entity = damagesource.getEntity()) instanceof Player && (player = (Player)entity).getInventory().getSelected().isEmpty()) {
            if (!player.isCreative()) {
                this.spawnAtLocation(serverLevel, (ItemLike)WMRegistries.ITEM_CANNON.get(), 1);
                if (this.isLoaded() || this.isLoading()) {
                    this.spawnAtLocation(serverLevel, (ItemLike)WMRegistries.ITEM_CANNON_BALL.get(), 1);
                    this.spawnAtLocation(serverLevel, (ItemLike)Items.GUNPOWDER, 1);
                }
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            return true;
        }
        this.setRockDirection(-this.getRockDirection());
        this.setHurtTime(10);
        this.setCurrentDamage(this.getCurrentDamage() + (int)damage * 5);
        this.markHurt();
        if (this.getCurrentDamage() > 100) {
            for (int j = 0; j < 6; ++j) {
                this.dropItemWithChance((Level)serverLevel, Items.IRON_INGOT, (int)damage, 1);
            }
            this.dropItemWithChance((Level)serverLevel, Items.FLINT, (int)damage, 1);
            this.dropItemWithChance((Level)serverLevel, Blocks.OAK_LOG.asItem(), (int)damage, 1);
            if (this.isLoaded() || this.isLoading()) {
                this.spawnAtLocation(serverLevel, (ItemLike)WMRegistries.ITEM_CANNON_BALL.get(), 1);
                this.spawnAtLocation(serverLevel, (ItemLike)Items.GUNPOWDER, 1);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    public void dropItemWithChance(Level level, Item item, int chance, int amount) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.random.nextInt(chance) < 10) {
                this.spawnAtLocation(serverLevel, (ItemLike)item, amount);
            }
        }
    }

    public void animateHurt(float yaw) {
        this.setRockDirection(-this.getRockDirection());
        this.setHurtTime(10);
        this.setCurrentDamage(this.getCurrentDamage() + 10);
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        super.baseTick();
        int i = this.getHurtTime();
        if (i > 0) {
            this.setHurtTime(i - 1);
        }
        if ((i = this.getCurrentDamage()) > 0) {
            this.setCurrentDamage(i - this.random.nextInt(2));
        }
        Vec3 motion = this.getDeltaMovement().subtract(0.0, 0.1, 0.0);
        if (this.onGround()) {
            motion = new Vec3(0.1 * motion.x, motion.y, 0.1 * motion.z);
        }
        motion = motion.scale(0.98);
        if (!this.onGround()) {
            this.fallDistance += (float)(-motion.y);
        }
        this.setDeltaMovement(motion);
        if (this.isVehicle()) {
            LivingEntity riddenByEntity = this.getControllingPassenger();
            float yaw = riddenByEntity.getYRot();
            float pitch = riddenByEntity.getXRot();
            this.setYRot(yaw % 360.0f);
            this.setXRot(pitch);
        }
        this.setRot(this.getYRot(), this.getXRot());
        this.move(MoverType.SELF, this.getDeltaMovement());
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.2, 0.0, 0.2), EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.hasPassenger((Entity)this) || entity.getVehicle() != null) continue;
                this.push(entity);
            }
        }
        if (this.isLoading()) {
            this.setLoadTimer(this.getLoadTimer() - 1);
            this.handleReloadTime();
        }
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        super.causeFallDamage(fallDistance, multiplier, source);
        int i = Mth.floor((float)fallDistance);
        this.hurt(this.damageSources().fall(), i *= 2);
        return false;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        if (this.isPassenger()) {
            return;
        }
        if (onGround) {
            if (this.fallDistance > 3.0f) {
                this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (!this.isRemoved()) {
                        this.kill(serverLevel);
                        if (serverLevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            for (int j = 0; j < 5; ++j) {
                                this.spawnAtLocation(serverLevel, (ItemLike)Items.IRON_INGOT);
                            }
                            this.spawnAtLocation(serverLevel, (ItemLike)Items.FLINT);
                            this.spawnAtLocation(serverLevel, (ItemLike)Blocks.OAK_LOG);
                            if (this.isLoaded() || this.isLoading()) {
                                this.spawnAtLocation(serverLevel, (ItemLike)WMRegistries.ITEM_CANNON_BALL.get());
                                this.spawnAtLocation(serverLevel, (ItemLike)Items.GUNPOWDER);
                            }
                        }
                    }
                }
            }
            this.resetFallDistance();
        } else if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && y < 0.0) {
            this.fallDistance -= (float)y;
        }
    }

    public void handleReloadTime() {
        int l = this.getLoadTimer();
        if (l > 0) {
            if (l == 80 || l == 70 || l == 60) {
                this.playSound(SoundEvents.PISTON_CONTRACT, 0.5f, 1.2f / (this.random.nextFloat() * 0.8f + 0.6f));
            } else if (l == 40) {
                this.playSound(SoundEvents.PLAYER_BREATH, 0.7f, 1.2f / (this.random.nextFloat() * 0.2f + 10.0f));
            }
        } else {
            this.setReloadInfo(true, 0);
        }
    }

    public void fireCannon() {
        if (!this.isLoaded()) {
            return;
        }
        LivingEntity entityPassenger = this.getControllingPassenger();
        if (entityPassenger != null && !this.level().isClientSide) {
            EntityCannonBall entitycannonball = new EntityCannonBall(this.level(), this, entityPassenger.getXRot(), entityPassenger.getYRot(), this.isSuperPowered(), null);
            this.level().addFreshEntity((Entity)entitycannonball);
        }
        this.setReloadInfo(false, 0);
        this.fireEffects();
    }

    public void fireEffects() {
        this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 8.0f, 1.0f / (this.random.nextFloat() * 0.8f + 0.9f));
        this.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 8.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.6f));
        float yaw = (float)Math.toRadians(this.getYRot());
        double d = -Mth.sin((float)yaw) * -1.0f;
        double d2 = Mth.cos((float)yaw) * -1.0f;
        if (this.level().isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + d + this.random.nextDouble() * 0.5 - 0.25, this.getY() + this.random.nextDouble() * 0.5, this.getZ() + d2 + this.random.nextDouble() * 0.5 - 0.25, this.random.nextDouble() * 0.1 - 0.05, this.random.nextDouble() * 0.1 - 0.05, this.random.nextDouble() * 0.1 - 0.05);
            }
        }
        if (this.isVehicle()) {
            for (Entity entity2 : this.getPassengers()) {
                entity2.setXRot(entity2.getXRot() + 10.0f);
            }
        }
        this.hurt(this.damageSources().generic(), 2.0f);
    }

    public void setReloadInfo(boolean loaded, int reloadtime) {
        this.setLoaded(loaded);
        this.setLoadTimer(reloadtime);
    }

    public void startLoadingCannon() {
        if (this.isLoaded() && !this.isLoading()) {
            return;
        }
        this.setReloadInfo(false, 100);
    }

    @NotNull
    public Vec3 getPassengerRidingPosition(Entity entity) {
        Vec3 orig = super.getPassengerRidingPosition(entity);
        if (this.hasPassenger(entity)) {
            float f = -0.85f;
            float f2 = this.isAlive() ? 0.35f : 0.01f;
            orig = orig.add(new Vec3((double)f, 0.0, 0.0).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f).add(0.0, (double)f2, 0.0));
        }
        return orig;
    }

    protected void addAdditionalSaveData(CompoundTag nbttagcompound) {
        nbttagcompound.putFloat("falld", this.fallDistance);
        nbttagcompound.putBoolean("load", this.isLoaded());
        nbttagcompound.putShort("ldtime", (short)this.getLoadTimer());
    }

    protected void readAdditionalSaveData(CompoundTag nbttagcompound) {
        this.setPos(this.getX(), this.getY(), this.getZ());
        this.setRot(this.getYRot(), this.getXRot());
        this.fallDistance = nbttagcompound.getFloat("falld");
        this.setLoaded(nbttagcompound.getBoolean("load"));
        this.setLoadTimer(nbttagcompound.getShort("ldtime"));
    }

    @NotNull
    public InteractionResult interact(Player entityplayer, @NotNull InteractionHand hand) {
        ItemStack itemstack = entityplayer.getItemInHand(hand);
        if (itemstack.getItem() == WMRegistries.ITEM_CANNON_BALL.get() && !this.isLoaded() && !this.isLoading() && (entityplayer.isCreative() || this.consumeAmmo(entityplayer, Items.GUNPOWDER))) {
            if (entityplayer.isCreative() || this.consumeAmmo(entityplayer, (Item)WMRegistries.ITEM_CANNON_BALL.get())) {
                this.startLoadingCannon();
                return InteractionResult.PASS;
            }
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnAtLocation(serverLevel, (ItemLike)Items.GUNPOWDER, 1);
            }
        } else {
            if (this.isVehicle() && this.riddenByPlayer() && this.notThisPlayer((Entity)entityplayer)) {
                return InteractionResult.PASS;
            }
            if (!this.level().isClientSide && !entityplayer.isShiftKeyDown()) {
                entityplayer.startRiding((Entity)this);
            }
        }
        return InteractionResult.PASS;
    }

    protected boolean consumeAmmo(Player entityplayer, Item itemAmmo) {
        return WMItem.consumeInventoryItem(entityplayer, itemAmmo);
    }

    public boolean riddenByPlayer() {
        LivingEntity entity = this.getControllingPassenger();
        return entity instanceof Player;
    }

    public boolean notThisPlayer(Entity player) {
        LivingEntity entity = this.getControllingPassenger();
        return entity != player;
    }

    public void thunderHit(@NotNull ServerLevel world, @NotNull LightningBolt entitylightningbolt) {
        this.hurt(this.damageSources().lightningBolt(), 100.0f);
        this.setSuperPowered(true);
    }

    public void setLoaded(boolean flag) {
        this.entityData.set(LOADED, (Object)((byte)(flag ? 1 : 0)));
    }

    public void setLoadTimer(int time) {
        this.entityData.set(LOAD_TIMER, (Object)time);
    }

    public void setSuperPowered(boolean flag) {
        this.entityData.set(SUPER_POWERED, (Object)((byte)(flag ? 1 : 0)));
    }

    public boolean isLoading() {
        return this.getLoadTimer() > 0;
    }

    public boolean isLoaded() {
        return (Byte)this.entityData.get(LOADED) != 0;
    }

    public int getLoadTimer() {
        return (Integer)this.entityData.get(LOAD_TIMER);
    }

    public boolean isSuperPowered() {
        return (Byte)this.entityData.get(SUPER_POWERED) != 0;
    }

    public void setHurtTime(int i) {
        this.entityData.set(TIME_SINCE_HIT, (Object)i);
    }

    public void setRockDirection(int i) {
        this.entityData.set(ROCK_DIRECTION, (Object)((byte)i));
    }

    public void setCurrentDamage(int i) {
        this.entityData.set(CURRENT_DAMAGE, (Object)i);
    }

    public int getHurtTime() {
        return (Integer)this.entityData.get(TIME_SINCE_HIT);
    }

    public int getRockDirection() {
        return ((Byte)this.entityData.get(ROCK_DIRECTION)).byteValue();
    }

    public int getCurrentDamage() {
        return (Integer)this.entityData.get(CURRENT_DAMAGE);
    }
}

