/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.DartType;
import ckathode.weaponmod.item.ItemBlowgunDart;
import dev.architectury.networking.NetworkManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityBlowgunDart
extends EntityProjectile<EntityBlowgunDart> {
    private static final EntityDataAccessor<Byte> DART_EFFECT_TYPE = SynchedEntityData.defineId(EntityBlowgunDart.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final float[][] DART_COLORS = new float[][]{{0.2f, 0.8f, 0.3f}, {0.9f, 0.7f, 1.0f}, {0.6f, 1.0f, 0.9f}, {0.8f, 0.5f, 0.2f}};
    public static final String ID = "dart";
    public static final EntityType<EntityBlowgunDart> TYPE = WMRegistries.createEntityType("dart", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityBlowgunDart::new);

    public EntityBlowgunDart(EntityType<EntityBlowgunDart> entityType, Level world) {
        super(entityType, world);
    }

    public EntityBlowgunDart(Level world, double d, double d1, double d2, @Nullable ItemStack firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPickupStatus(EntityProjectile.PickupStatus.ALLOWED);
        this.setPos(d, d1, d2);
    }

    public EntityBlowgunDart(Level world, LivingEntity shooter, @Nullable ItemStack firedFromWeapon) {
        this(world, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ(), firedFromWeapon);
        this.setOwner((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DART_EFFECT_TYPE, (Object)0);
    }

    public void setDartEffectType(DartType type) {
        this.setDartEffectType(type.typeID());
    }

    public void setDartEffectType(byte i) {
        this.entityData.set(DART_EFFECT_TYPE, (Object)i);
    }

    public DartType getDartEffectType() {
        return DartType.dartTypes[this.getDartEffectId()];
    }

    public byte getDartEffectId() {
        byte effectId = (Byte)this.entityData.get(DART_EFFECT_TYPE);
        if (effectId < 0) {
            effectId = 0;
        }
        return effectId;
    }

    public float[] getDartColor() {
        byte effectId = this.getDartEffectId();
        return DART_COLORS[effectId >= DART_COLORS.length ? (byte)0 : effectId];
    }

    @Override
    @NotNull
    public DamageSource getDamageSource() {
        return this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity.hurtOrSimulate(this.getDamageSource(), 1.0f + this.extraDamage)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(this.getDartEffectType().potionEffect()));
            }
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public double getDefaultGravity() {
        return 0.05f;
    }

    @Override
    public void playHitSound() {
        this.playSound(SoundEvents.ARROW_HIT, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.2f));
    }

    @Override
    public int getMaxArrowShake() {
        return 4;
    }

    @Override
    @NotNull
    public ItemStack getPickupItem() {
        return new ItemStack((ItemLike)ItemBlowgunDart.ITEMS.get(this.getDartEffectType()));
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ItemBlowgunDart.ITEMS.get(DartType.damage));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putByte("darttype", this.getDartEffectId());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.setDartEffectType(nbttagcompound.getByte("darttype"));
    }
}

