/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.entity.projectile.EntityProjectile;
import ckathode.weaponmod.item.RangedComponent;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityBlunderShot
extends EntityProjectile<EntityBlunderShot> {
    public static final String ID = "shot";
    public static final EntityType<EntityBlunderShot> TYPE = WMRegistries.createEntityType("shot", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityBlunderShot::new);

    public EntityBlunderShot(EntityType<EntityBlunderShot> entityType, Level world) {
        super(entityType, world);
        this.setPickupStatus(EntityProjectile.PickupStatus.DISALLOWED);
    }

    public EntityBlunderShot(Level world, double x, double y, double z, @Nullable ItemStack firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPos(x, y, z);
    }

    public EntityBlunderShot(Level world, LivingEntity shooter, @Nullable ItemStack firedFromWeapon) {
        this(world, shooter.getX(), shooter.getEyeY() - 0.1, shooter.getZ(), firedFromWeapon);
        this.setOwner((Entity)shooter);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f3, f4);
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksInAir > 4) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    @NotNull
    public DamageSource getDamageSource() {
        return this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, this.getDamagingEntity());
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        float damage = 4.0f + this.extraDamage;
        int prevhurtrestime = entity.invulnerableTime;
        if (entity.hurtOrSimulate(this.getDamageSource(), damage)) {
            entity.invulnerableTime = prevhurtrestime;
            this.applyEntityHitEffects(entity);
            this.playHitSound();
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public boolean aimRotation() {
        return false;
    }

    @Override
    public int getMaxLifetime() {
        return 200;
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    public double getDefaultGravity() {
        return this.getTotalVelocity() < 2.0 ? (double)0.04f : 0.0;
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_BLUNDER_SHOT.get());
    }

    public static void fireSpreadShot(Level world, LivingEntity entityliving, RangedComponent item, ItemStack itemstack) {
        for (int i = 0; i < 10; ++i) {
            EntityBlunderShot entity = new EntityBlunderShot(world, entityliving, itemstack);
            entity.shootFromRotation((Entity)entityliving, entityliving.getXRot(), entityliving.getYRot(), 0.0f, 5.0f, 15.0f);
            if (item != null && !itemstack.isEmpty()) {
                item.applyProjectileEnchantments(entity, itemstack);
            }
            world.addFreshEntity((Entity)entity);
        }
    }

    public static void fireFromDispenser(Level world, double d, double d1, double d2, int i, int j, int k) {
        for (int i2 = 0; i2 < 10; ++i2) {
            EntityBlunderShot entityblundershot = new EntityBlunderShot(world, d, d1, d2, null);
            entityblundershot.shoot(i, j, k, 5.0f, 15.0f);
            world.addFreshEntity((Entity)entityblundershot);
        }
    }
}

