/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.WMItemBuilder;
import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.item.WMItem;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ItemCannon
extends WMItem {
    public static final String ID = "cannon";
    public static final ItemCannon ITEM = WMItemBuilder.createStandardCannon(BalkonsWeaponMod.id("cannon"));
    private static final Predicate<Entity> PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);

    public ItemCannon(@NotNull ResourceLocation id) {
        super(WMItem.getBaseProperties(id).enchantable(10).stacksTo(1));
    }

    @NotNull
    public InteractionResult use(@NotNull Level world, @NotNull Player entityplayer, @NotNull InteractionHand hand) {
        Block block;
        ItemStack itemstack = entityplayer.getItemInHand(hand);
        BlockHitResult raytraceresult = ItemCannon.getPlayerPOVHitResult((Level)world, (Player)entityplayer, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (raytraceresult.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        Vec3 lookVec = entityplayer.getViewVector(1.0f);
        double f = 5.0;
        List entities = world.getEntities((Entity)entityplayer, entityplayer.getBoundingBox().expandTowards(lookVec.scale(f)).inflate(1.0), PREDICATE);
        if (!entities.isEmpty()) {
            Vec3 eyePos = entityplayer.getEyePosition(1.0f);
            for (Entity e : entities) {
                AABB aabb = e.getBoundingBox().inflate((double)e.getPickRadius());
                if (!aabb.contains(eyePos)) continue;
                return InteractionResult.PASS;
            }
        }
        boolean flag1 = (block = world.getBlockState(raytraceresult.getBlockPos()).getBlock()) == Blocks.SNOW;
        EntityCannon entitycannon = new EntityCannon(world, raytraceresult.getLocation().x + 0.5, raytraceresult.getLocation().y + (flag1 ? 0.38 : 1.0), raytraceresult.getLocation().z + 0.5);
        entitycannon.setYRot(entityplayer.getYRot());
        if (!world.noCollision((Entity)entitycannon, entitycannon.getBoundingBox().inflate(-0.1))) {
            return InteractionResult.FAIL;
        }
        if (!world.isClientSide) {
            world.addFreshEntity((Entity)entitycannon);
        }
        if (!entityplayer.isCreative()) {
            itemstack.shrink(1);
        }
        entityplayer.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.SUCCESS;
    }
}

