/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeComponent;
import ckathode.weaponmod.item.RangedComponent;
import ckathode.weaponmod.item.WMItem;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemShooter
extends BowItem
implements IItemWeapon {
    protected static final int MAX_DELAY = 72000;
    public final RangedComponent rangedComponent;
    public final MeleeComponent meleeComponent;

    public ItemShooter(RangedComponent rangedcomponent, MeleeComponent meleecomponent, @NotNull ResourceLocation id) {
        this(rangedcomponent, meleecomponent, WMItem.getBaseProperties(meleecomponent.weaponMaterial, id));
    }

    public ItemShooter(RangedComponent rangedcomponent, MeleeComponent meleecomponent, Item.Properties properties) {
        super(rangedcomponent.setProperties(meleecomponent.setProperties(properties)).attributes(rangedcomponent.setAttributes(meleecomponent.setAttributes(ItemAttributeModifiers.builder())).build()).enchantable(meleecomponent.getEnchantmentValue()).arch$tab(CreativeModeTabs.COMBAT));
        this.rangedComponent = rangedcomponent;
        this.meleeComponent = meleecomponent;
        rangedcomponent.setItem(this);
        meleecomponent.setItem(this);
    }

    public boolean hurtEnemy(@NotNull ItemStack itemstack, @NotNull LivingEntity entityliving, @NotNull LivingEntity attacker) {
        return this.meleeComponent.hurtEnemy(itemstack, entityliving, attacker);
    }

    public boolean mineBlock(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull BlockState block, @NotNull BlockPos pos, @NotNull LivingEntity entityliving) {
        return this.meleeComponent.mineBlock(itemstack, world, block, pos, entityliving);
    }

    @Override
    public boolean onLeftClickEntity(@NotNull ItemStack itemstack, @NotNull Player player, @NotNull Entity entity) {
        return this.meleeComponent.onLeftClickEntity(itemstack, player, entity) && this.rangedComponent.onLeftClickEntity(itemstack, player, entity);
    }

    @NotNull
    public ItemUseAnimation getUseAnimation(@NotNull ItemStack itemstack) {
        return this.rangedComponent.getUseAnimation(itemstack);
    }

    public int getUseDuration(@NotNull ItemStack itemstack, LivingEntity livingEntity) {
        return this.rangedComponent.getUseDuration(itemstack);
    }

    @NotNull
    public InteractionResult use(@NotNull Level world, @NotNull Player entityplayer, @NotNull InteractionHand hand) {
        return this.rangedComponent.use(entityplayer.getItemInHand(hand), world, entityplayer, hand);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.rangedComponent.onUsingTick(level, livingEntity, stack, remainingUseDuration);
    }

    public boolean releaseUsing(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull LivingEntity entityplayer, int i) {
        return this.rangedComponent.releaseUsing(itemstack, world, entityplayer, i);
    }

    public void inventoryTick(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull Entity entity, int i, boolean flag) {
        this.meleeComponent.inventoryTick(itemstack, world, entity, i, flag);
        this.rangedComponent.inventoryTick(itemstack, world, entity, i, flag);
    }

    @Override
    public MeleeComponent getMeleeComponent() {
        return this.meleeComponent;
    }

    @Override
    public RangedComponent getRangedComponent() {
        return this.rangedComponent;
    }
}

