/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.render.ModelCannonBarrel;
import ckathode.weaponmod.render.ModelCannonLegacy;
import ckathode.weaponmod.render.ModelCannonStandard;
import ckathode.weaponmod.render.WMRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RenderCannon
extends WMRenderer<EntityCannon, CannonRenderState> {
    private final ModelCannonBarrel modelBarrel;
    private final ModelCannonStandard modelStandard;
    private final ModelCannonLegacy modelLegacy;

    public RenderCannon(EntityRendererProvider.Context context) {
        super(context);
        this.modelBarrel = new ModelCannonBarrel(context.bakeLayer(ModelCannonBarrel.CANNON_BARREL_LAYER));
        this.modelStandard = new ModelCannonStandard(context.bakeLayer(ModelCannonStandard.CANNON_STANDARD_LAYER));
        this.modelLegacy = new ModelCannonLegacy(context.bakeLayer(ModelCannonLegacy.CANNON_LEGACY_LAYER));
        this.shadowRadius = 0.7f;
    }

    public void render(CannonRenderState entityRenderState, PoseStack ms, MultiBufferSource bufs, int lm) {
        ms.pushPose();
        if (WeaponModConfig.get().legacyCannonModel) {
            ms.translate(0.0, 0.1, 0.0);
            ms.mulPose(Axis.YP.rotationDegrees(-entityRenderState.yRot));
        } else {
            ms.translate(0.0f, 2.375f, 0.0f);
            ms.mulPose(Axis.YP.rotationDegrees(180.0f - entityRenderState.yRot));
        }
        float f2 = entityRenderState.hurtTime;
        float f3 = entityRenderState.currentDamage;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            ms.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)f2) * f2 * f3 / 10.0f * (float)entityRenderState.rockDirection / 5.0f));
        }
        int color = -3355444;
        if (entityRenderState.superPowered && entityRenderState.tickCount % 5 < 2) {
            color = -1;
        }
        if (WeaponModConfig.get().legacyCannonModel) {
            VertexConsumer builder = bufs.getBuffer(RenderType.entityCutout((ResourceLocation)WeaponModResources.Entity.CANNON_LEGACY));
            ms.scale(-1.0f, -1.0f, 1.0f);
            ms.mulPose(Axis.XP.rotationDegrees(180.0f));
            this.modelLegacy.barrel.xRot = Math.max(-entityRenderState.xRot / 120.0f, -0.25f);
            this.modelLegacy.renderToBuffer(ms, builder, lm, OverlayTexture.NO_OVERLAY, color);
        } else {
            float yawRadians;
            float rot = Math.min(entityRenderState.xRot, 20.0f);
            VertexConsumer builder = bufs.getBuffer(RenderType.entityCutout((ResourceLocation)WeaponModResources.Entity.CANNON));
            ms.scale(-1.6f, -1.6f, 1.6f);
            ms.pushPose();
            ms.translate(0.0f, 1.0f, 0.0f);
            ms.mulPose(Axis.XP.rotationDegrees(rot));
            ms.translate(0.0f, -1.0f, 0.0f);
            this.modelBarrel.renderToBuffer(ms, builder, lm, OverlayTexture.NO_OVERLAY, color);
            ms.popPose();
            this.modelStandard.base1.yRot = yawRadians = -((float)Math.toRadians(entityRenderState.yRot));
            this.modelStandard.base2.yRot = yawRadians;
            this.modelStandard.baseStand.yRot = yawRadians;
            this.modelStandard.renderToBuffer(ms, builder, lm, OverlayTexture.NO_OVERLAY, color);
        }
        ms.popPose();
        super.render((EntityRenderState)entityRenderState, ms, bufs, lm);
    }

    @NotNull
    public CannonRenderState createRenderState() {
        return new CannonRenderState();
    }

    @Override
    public void extractRenderState(EntityCannon entity, CannonRenderState entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        entityRenderState.tickCount = entity.tickCount;
        entityRenderState.hurtTime = entity.getHurtTime();
        entityRenderState.currentDamage = entity.getCurrentDamage();
        entityRenderState.rockDirection = entity.getRockDirection();
        entityRenderState.superPowered = entity.isSuperPowered();
    }

    public static class CannonRenderState
    extends WMRenderer.WMRendererState {
        public int tickCount;
        public int hurtTime;
        public int currentDamage;
        public int rockDirection;
        public boolean superPowered;
    }
}

