/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.render;

import ckathode.weaponmod.WeaponModResources;
import ckathode.weaponmod.entity.EntityDummy;
import ckathode.weaponmod.render.ModelDummy;
import ckathode.weaponmod.render.WMRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RenderDummy
extends WMRenderer<EntityDummy, DummyRenderState> {
    private final ModelDummy modelDummy;

    public RenderDummy(EntityRendererProvider.Context context) {
        super(context);
        this.modelDummy = new ModelDummy(context.bakeLayer(ModelDummy.MAIN_LAYER));
        this.shadowRadius = 0.7f;
    }

    public void render(DummyRenderState entityRenderState, PoseStack ms, MultiBufferSource bufs, int lm) {
        ms.pushPose();
        ms.translate(0.0f, -0.025f, 0.0f);
        ms.mulPose(Axis.YP.rotationDegrees(180.0f - entityRenderState.yRot));
        float f2 = entityRenderState.timeSinceHit;
        float f3 = entityRenderState.currentDamage;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            ms.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)f2) * f2 * f3 / 10.0f * (float)entityRenderState.rockDirection / 5.0f));
        }
        VertexConsumer builder = bufs.getBuffer(RenderType.entityCutout((ResourceLocation)WeaponModResources.Entity.DUMMY));
        ms.scale(-1.0f, -1.0f, 1.0f);
        ms.mulPose(Axis.XP.rotationDegrees(180.0f));
        this.modelDummy.renderToBuffer(ms, builder, lm, OverlayTexture.NO_OVERLAY);
        ms.popPose();
        super.render((EntityRenderState)entityRenderState, ms, bufs, lm);
    }

    @NotNull
    public DummyRenderState createRenderState() {
        return new DummyRenderState();
    }

    @Override
    public void extractRenderState(EntityDummy entity, DummyRenderState entityRenderState, float f) {
        super.extractRenderState(entity, entityRenderState, f);
        entityRenderState.timeSinceHit = (float)entity.getTimeSinceHit() - f;
        entityRenderState.currentDamage = (float)entity.getCurrentDamage() - f;
        entityRenderState.rockDirection = entity.getRockDirection();
    }

    public static class DummyRenderState
    extends WMRenderer.WMRendererState {
        public float timeSinceHit;
        public float currentDamage;
        public int rockDirection;
    }
}

