/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.WMUtil;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4770;
import net.minecraft.class_5362;
import net.minecraft.class_5819;
import net.minecraft.class_9892;
import org.jetbrains.annotations.Nullable;

public class AdvancedExplosion
extends class_9892 {
    protected static final Random rand = new Random();
    public final ObjectArrayList<class_2338> toBlow = new ObjectArrayList();
    public final class_3218 serverLevel;
    public final class_1282 damageSource;
    public final class_243 center;
    public final class_1297 exploder;
    public final float explosionSize;
    protected boolean blocksCalculated;

    public AdvancedExplosion(class_3218 world, class_1297 entity, class_243 position, float size, boolean flame, class_1927.class_4179 mode) {
        this(world, entity, null, null, position, size, flame, mode);
    }

    public AdvancedExplosion(class_3218 world, class_1297 entity, @Nullable class_1282 source, @Nullable class_5362 calculator, class_243 position, float size, boolean flame, class_1927.class_4179 mode) {
        super(world, entity, source, calculator, position, size, flame, mode);
        this.serverLevel = world;
        this.damageSource = world.method_48963().method_48807((class_1927)this);
        this.exploder = entity;
        this.center = position;
        this.explosionSize = size;
    }

    public void setAffectedBlockPositions(List<class_2338> list) {
        this.toBlow.addAll(list);
        this.blocksCalculated = true;
    }

    public void doEntityExplosion() {
        this.doEntityExplosion(this.damageSource);
    }

    public void doEntityExplosion(class_1282 damagesource) {
        float size = this.explosionSize * 2.0f;
        int k1 = class_3532.method_15357((double)(this.center.field_1352 - (double)size - 1.0));
        int l1 = class_3532.method_15357((double)(this.center.field_1352 + (double)size + 1.0));
        int i2 = class_3532.method_15357((double)(this.center.field_1351 - (double)size - 1.0));
        int i3 = class_3532.method_15357((double)(this.center.field_1351 + (double)size + 1.0));
        int j2 = class_3532.method_15357((double)(this.center.field_1350 - (double)size - 1.0));
        int j3 = class_3532.method_15357((double)(this.center.field_1350 + (double)size + 1.0));
        List list = this.serverLevel.method_8335(this.exploder, new class_238((double)k1, (double)i2, (double)j2, (double)l1, (double)i3, (double)j3));
        for (class_1297 entity : list) {
            class_243 d;
            double dr;
            if (entity.method_5659((class_1927)this) || !((dr = Math.sqrt(entity.method_5707(this.center)) / (double)size) <= 1.0) || (d = entity.method_73189().method_1020(this.center)).method_1027() == 0.0) continue;
            d = d.method_1029();
            double dens = AdvancedExplosion.method_61731((class_243)this.center, (class_1297)entity);
            double var36 = (1.0 - dr) * dens;
            int damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)size + 1.0);
            entity.method_64397(this.serverLevel, damagesource, (float)damage);
            entity.method_18799(entity.method_18798().method_1031(d.field_1352 * var36, d.field_1351 * var36, d.field_1350 * var36));
        }
    }

    public void doBlockExplosion() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        ObjectArrayList positions = new ObjectArrayList(this.toBlow);
        ArrayList list = new ArrayList();
        class_156.method_43028((List)positions, (class_5819)WMUtil.RANDOM);
        for (class_2338 blockPos2 : positions) {
            this.serverLevel.method_8320(blockPos2).method_55225(this.serverLevel, blockPos2, (class_1927)this, (itemStack, blockPos) -> class_9892.method_61733((List)list, (class_1799)itemStack, (class_2338)blockPos));
        }
        for (class_9892.class_9893 collector : list) {
            class_2248.method_9577((class_1937)this.serverLevel, (class_2338)collector.field_52629, (class_1799)collector.field_52630);
        }
    }

    public void doFlaming() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (class_2338 blockpos : this.toBlow) {
            if (rand.nextInt(3) != 0 || !this.serverLevel.method_8320(blockpos).method_26215() || !this.serverLevel.method_8320(blockpos.method_10074()).method_26216()) continue;
            this.serverLevel.method_8501(blockpos, class_4770.method_24416((class_1922)this.serverLevel, (class_2338)blockpos));
        }
    }

    public void doParticleExplosion(boolean smallparticles, boolean bigparticles) {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        AdvancedExplosion.doParticleExplosion((class_1937)this.serverLevel, this.center, this.toBlow, this.explosionSize, smallparticles, bigparticles);
    }

    public static void doParticleExplosion(class_1937 level, class_243 center, Collection<class_2338> toBlow, float explosionSize, boolean smallparticles, boolean bigparticles) {
        level.method_43128(null, center.field_1352, center.field_1351, center.field_1350, (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245, 4.0f, (1.0f + (WMUtil.RANDOM.method_43057() - WMUtil.RANDOM.method_43057()) * 0.2f) * 0.7f);
        if (bigparticles && level.method_8608()) {
            level.method_8406((class_2394)class_2398.field_11236, center.field_1352, center.field_1351, center.field_1350, 0.0, 0.0, 0.0);
        }
        if (!smallparticles) {
            return;
        }
        for (class_2338 blockpos : toBlow) {
            double px = (float)blockpos.method_10263() + WMUtil.RANDOM.method_43057();
            double py = (float)blockpos.method_10264() + WMUtil.RANDOM.method_43057();
            double pz = (float)blockpos.method_10260() + WMUtil.RANDOM.method_43057();
            double dx = px - center.field_1352;
            double dy = py - center.field_1351;
            double dz = pz - center.field_1350;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            dx /= distance;
            dy /= distance;
            dz /= distance;
            double d7 = 0.5 / (distance / (double)explosionSize + 0.1);
            dx *= (d7 *= (double)(WMUtil.RANDOM.method_43057() * WMUtil.RANDOM.method_43057() + 0.3f));
            dy *= d7;
            dz *= d7;
            if (!level.method_8608()) continue;
            level.method_8406((class_2394)class_2398.field_11203, (px + center.field_1352) / 2.0, (py + center.field_1351) / 2.0, (pz + center.field_1350) / 2.0, dx, dy, dz);
            level.method_8406((class_2394)class_2398.field_11251, px, py, pz, dx, dy, dz);
        }
    }

    protected void calculateBlockExplosion() {
        int maxsize = 16;
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < maxsize; ++j) {
            for (int k = 0; k < maxsize; ++k) {
                for (int l = 0; l < maxsize; ++l) {
                    if (j != 0 && j != maxsize - 1 && k != 0 && k != maxsize - 1 && l != 0 && l != maxsize - 1) continue;
                    double rx = (float)j / 15.0f * 2.0f - 1.0f;
                    double ry = (float)k / 15.0f * 2.0f - 1.0f;
                    double rz = (float)l / 15.0f * 2.0f - 1.0f;
                    double rd = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    rx /= rd;
                    ry /= rd;
                    rz /= rd;
                    double dx = this.center.field_1352;
                    double dy = this.center.field_1351;
                    double dz = this.center.field_1350;
                    float f = 0.3f;
                    for (float strength = this.explosionSize * (0.7f + WMUtil.RANDOM.method_43057() * 0.6f); strength > 0.0f; strength -= 0.22500001f) {
                        class_2338 blockpos = class_2338.method_49637((double)dx, (double)dy, (double)dz);
                        class_2680 iblockstate = this.serverLevel.method_8320(blockpos);
                        if (!iblockstate.method_26215()) {
                            strength -= (iblockstate.method_26204().method_9520() + 0.3f) * f;
                        }
                        if (strength > 0.0f) {
                            set.add(blockpos);
                        }
                        dx += rx * 0.3;
                        dy += ry * 0.3;
                        dz += rz * 0.3;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        this.blocksCalculated = true;
    }
}

