/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.WeaponModConfig;
import ckathode.weaponmod.entity.projectile.fabric.EntityProjectileImpl;
import com.mojang.serialization.Codec;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_10774;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityProjectile<T extends EntityProjectile<T>>
extends class_1665
implements EntitySpawnExtension {
    private static final class_2940<Byte> WEAPON_CRITICAL = class_2945.method_12791(EntityProjectile.class, (class_2941)class_2943.field_13319);
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    @Nullable
    protected class_2680 inBlockState = null;
    protected boolean inGround = false;
    public PickupStatus pickupStatus;
    protected int ticksInGround;
    protected int ticksInAir;
    public boolean beenInGround;
    public float extraDamage;
    private class_1297 shooter;
    @Nullable
    private class_1799 firedFromWeapon = null;

    public EntityProjectile(class_1299<T> type, class_1937 world) {
        super(type, world);
        this.field_7574 = 0;
        this.ticksInAir = 0;
        this.pickupStatus = PickupStatus.DISALLOWED;
        this.extraDamage = 0.0f;
    }

    public EntityProjectile(class_1299<T> type, class_1937 level, @Nullable class_1799 firedFromWeapon) {
        this(type, level);
        if (firedFromWeapon != null && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.firedFromWeapon = firedFromWeapon.method_7972();
            if (this.firedFromWeapon.method_7960()) {
                throw new IllegalArgumentException("Invalid weapon firing an arrow");
            }
            class_1890.method_60127((class_3218)serverLevel, (class_1799)this.firedFromWeapon, this, item -> {
                this.firedFromWeapon = null;
            });
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(WEAPON_CRITICAL, (Object)0);
    }

    public void saveAdditionalSpawnData(class_2540 buf) {
        class_1297 shooter = this.method_24921();
        buf.method_53002(shooter != null ? shooter.method_5628() : -1);
    }

    public void loadAdditionalSpawnData(class_2540 buf) {
        int shooterId = buf.readInt();
        if (shooterId >= 0) {
            this.method_7432(this.method_73183().method_8469(shooterId));
        }
    }

    public void method_7432(@Nullable class_1297 shooter) {
        this.shooter = shooter;
        super.method_7432(shooter);
    }

    @Nullable
    public class_1297 method_24921() {
        if (this.shooter != null) {
            return this.shooter;
        }
        return super.method_24921();
    }

    protected void setPickupStatusFromEntity(class_1309 entityliving) {
        if (entityliving instanceof class_1657) {
            class_1657 player = (class_1657)entityliving;
            if (player.method_68878()) {
                this.setPickupStatus(PickupStatus.CREATIVE_ONLY);
            } else {
                this.setPickupStatus(WeaponModConfig.get().allCanPickup ? PickupStatus.ALLOWED : PickupStatus.OWNER_ONLY);
            }
        } else {
            this.setPickupStatus(PickupStatus.DISALLOWED);
        }
    }

    public class_1297 getDamagingEntity() {
        class_1297 shooter = this.method_24921();
        return shooter != null ? shooter : this;
    }

    public void method_7485(double x, double y, double z, float speed, float deviation) {
        class_243 v = new class_243(x, y, z).method_1029().method_1031(this.field_5974.method_43059() * 0.0075 * (double)deviation, this.field_5974.method_43059() * 0.0075 * (double)deviation, this.field_5974.method_43059() * 0.0075 * (double)deviation).method_1021((double)speed);
        this.method_18799(v);
        double f2 = v.method_37267();
        float n = (float)(class_3532.method_15349((double)v.field_1352, (double)v.field_1350) * 180.0 / Math.PI);
        this.method_36456(n);
        this.field_5982 = n;
        float n2 = (float)(class_3532.method_15349((double)v.field_1351, (double)f2) * 180.0 / Math.PI);
        this.method_36457(n2);
        this.field_6004 = n2;
        this.ticksInGround = 0;
    }

    public void method_5750(class_243 vec3) {
        this.method_18799(vec3);
        if (this.aimRotation() && this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double f = vec3.method_37267();
            float n = (float)(class_3532.method_15349((double)vec3.field_1352, (double)vec3.field_1350) * 180.0 / Math.PI);
            this.method_36456(n);
            this.field_5982 = n;
            float n2 = (float)(class_3532.method_15349((double)vec3.field_1351, (double)f) * 180.0 / Math.PI);
            this.method_36457(n2);
            this.field_6004 = n2;
            this.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            this.ticksInGround = 0;
        }
    }

    public void method_5773() {
        this.method_5670();
    }

    public void method_5670() {
        class_265 voxelShape;
        super.method_5670();
        class_243 motion = this.method_18798();
        if (this.aimRotation() && this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double f = motion.method_37267();
            this.method_36456((float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 180.0 / Math.PI));
            this.method_36457((float)(class_3532.method_15349((double)motion.field_1351, (double)f) * 180.0 / Math.PI));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        class_2338 blockpos = new class_2338(this.xTile, this.yTile, this.zTile);
        class_2680 iblockstate = this.method_73183().method_8320(blockpos);
        if (!iblockstate.method_26215() && !(voxelShape = iblockstate.method_26220((class_1922)this.method_73183(), blockpos)).method_1110() && voxelShape.method_1107().method_996(blockpos).method_1006(new class_243(this.method_23317(), this.method_23318(), this.method_23321()))) {
            this.inGround = true;
        }
        if (this.field_7574 > 0) {
            --this.field_7574;
        }
        if (this.method_5721()) {
            this.method_5646();
        }
        if (this.inGround) {
            if (!iblockstate.equals((Object)this.inBlockState) && this.method_73183().method_18026(this.method_5829().method_1014(0.06))) {
                this.inGround = false;
                this.method_18799(motion.method_18805((double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f), (double)(this.field_5974.method_43057() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else if (!this.method_73183().method_8608()) {
                ++this.ticksInGround;
                int t = this.getMaxLifetime();
                if (t != 0 && this.ticksInGround >= t) {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            }
            ++this.field_7576;
            return;
        }
        this.field_7576 = 0;
        ++this.ticksInAir;
        class_243 vec3d = this.method_73189();
        class_243 vec3d2 = vec3d.method_1019(this.method_18798());
        class_3965 raytraceresult = this.method_73183().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (raytraceresult.method_17783() != class_239.class_240.field_1333) {
            vec3d2 = raytraceresult.method_17784();
        }
        while (this.method_5805()) {
            class_3966 entityraytraceresult = this.method_7434(vec3d, vec3d2);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult instanceof class_3966) {
                class_3966 ehr = (class_3966)raytraceresult;
                class_1297 entity = ehr.method_17782();
                class_1297 entity2 = this.method_24921();
                if (entity instanceof class_1657) {
                    class_1657 player2;
                    class_1657 player = (class_1657)entity;
                    if (entity2 instanceof class_1657 && !(player2 = (class_1657)entity2).method_7256(player)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
            }
            if (raytraceresult != null && raytraceresult.method_17783() != class_239.class_240.field_1333 && !EntityProjectile.onProjectileImpact(this, (class_239)raytraceresult)) {
                this.method_7488((class_239)raytraceresult);
                this.field_6007 = true;
            }
            if (entityraytraceresult == null || this.method_7447() <= 0) break;
            raytraceresult = null;
        }
        if (this.method_7443()) {
            class_243 motion2 = this.method_18798();
            for (int i1 = 0; i1 < 2; ++i1) {
                class_243 pos = this.method_73189().method_1019(motion2.method_1021((double)i1 / 4.0));
                if (!this.method_73183().method_8608()) continue;
                this.method_73183().method_8406((class_2394)class_2398.field_11205, pos.field_1352, pos.field_1351, pos.field_1350, -motion2.field_1352, -motion2.field_1351 + 0.2, -motion2.field_1350);
            }
        }
        class_243 newPos = this.method_73189().method_1019(this.method_18798());
        this.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        if (this.aimRotation()) {
            float n4;
            class_243 motion2 = this.method_18798();
            double f2 = motion2.method_37267();
            float n3 = (float)(class_3532.method_15349((double)motion2.field_1352, (double)motion2.field_1350) * 180.0 / Math.PI);
            this.method_36456(n3);
            this.field_5982 = n3;
            this.field_5965 = n4 = (float)(class_3532.method_15349((double)motion2.field_1351, (double)f2) * 180.0 / Math.PI);
            this.field_6004 = n4;
        }
        float res = this.getAirResistance();
        double grav = this.method_56989();
        if (this.method_5799()) {
            class_243 motion2 = this.method_18798();
            this.beenInGround = true;
            for (int i2 = 0; i2 < 4; ++i2) {
                float f3 = 0.25f;
                class_243 pos = this.method_73189().method_1020(motion2.method_1021((double)f3));
                if (!this.method_73183().method_8608()) continue;
                this.method_73183().method_8406((class_2394)class_2398.field_11205, pos.field_1352, pos.field_1351, pos.field_1350, motion2.field_1352, motion2.field_1351 + 0.2, motion2.field_1350);
            }
            res *= 0.6f;
        }
        this.method_18799(this.method_18798().method_1021((double)res).method_1023(0.0, this.method_5740() ? 0.0 : grav, 0.0));
        this.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_61409();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean onProjectileImpact(EntityProjectile<?> projectile, class_239 hitResult) {
        void var1_1;
        return EntityProjectileImpl.onProjectileImpact(projectile, (class_239)var1_1);
    }

    public void method_7488(@NotNull class_239 result) {
        if (result instanceof class_3966) {
            class_3966 ehr = (class_3966)result;
            this.method_7454(ehr);
        } else if (result instanceof class_3965) {
            class_3965 bhr = (class_3965)result;
            this.method_24920(bhr);
        }
    }

    public void method_7454(class_3966 result) {
        this.bounceBack();
        this.applyEntityHitEffects(result.method_17782());
    }

    @NotNull
    public class_1282 getDamageSource() {
        return this.method_48923().method_48803((class_1665)this, this.shooter);
    }

    public void applyEntityHitEffects(class_1297 entity) {
        if (this.method_5809() && !(entity instanceof class_1560)) {
            entity.method_5639(5.0f);
        }
        if (entity instanceof class_1309) {
            class_1297 shooter;
            class_1309 livingEntity = (class_1309)entity;
            this.method_59957(livingEntity, this.getDamageSource());
            class_1937 class_19372 = this.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_1890.method_60619((class_3218)serverLevel, (class_1297)livingEntity, (class_1282)this.getDamageSource(), (class_1799)this.method_59958());
            }
            if ((shooter = this.method_24921()) instanceof class_3222) {
                class_3222 sp = (class_3222)shooter;
                if (!entity.equals((Object)this.method_24921()) && entity instanceof class_1657) {
                    sp.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
                }
            }
        }
    }

    public void method_24920(class_3965 result) {
        class_2338 blockpos = result.method_17777();
        this.xTile = blockpos.method_10263();
        this.yTile = blockpos.method_10264();
        this.zTile = blockpos.method_10260();
        this.inBlockState = this.method_73183().method_8320(blockpos);
        this.method_18799(result.method_17784().method_1020(this.method_73189()));
        double f1 = this.method_18798().method_1033();
        class_243 pos = this.method_73189().method_1020(this.method_18798().method_1021(0.05 / f1));
        this.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        this.inGround = true;
        this.beenInGround = true;
        this.method_7439(false);
        this.field_7574 = this.getMaxArrowShake();
        this.playHitSound();
        if (this.inBlockState != null) {
            this.inBlockState.method_26178(this.method_73183(), blockpos, (class_1297)this, class_10774.field_56634);
        }
    }

    protected void bounceBack() {
        this.method_18799(this.method_18798().method_1021(-0.1));
        this.method_36456(this.method_36454() + 180.0f);
        this.field_5982 += 180.0f;
        this.ticksInAir = 0;
    }

    public double getTotalVelocity() {
        return this.method_18798().method_1033();
    }

    public boolean aimRotation() {
        return true;
    }

    public int getMaxLifetime() {
        return 1200;
    }

    public float getAirResistance() {
        return 0.99f;
    }

    public double method_7490() {
        return 0.05;
    }

    public int getMaxArrowShake() {
        return 7;
    }

    @NotNull
    protected class_1799 method_57314() {
        return new class_1799((class_1935)class_1802.field_8107);
    }

    @NotNull
    protected class_1799 method_7445() {
        return this.method_57314();
    }

    @Nullable
    public class_1799 method_31480() {
        return this.method_7445();
    }

    public void playHitSound() {
    }

    public boolean canBeCritical() {
        return false;
    }

    public void method_7439(boolean flag) {
        if (this.canBeCritical()) {
            this.field_6011.method_12778(WEAPON_CRITICAL, (Object)((byte)(flag ? 1 : 0)));
        }
    }

    public boolean method_7443() {
        return this.canBeCritical() && (Byte)this.field_6011.method_12789(WEAPON_CRITICAL) != 0;
    }

    public void setExtraDamage(float f) {
        this.extraDamage = f;
    }

    protected void method_59957(class_1309 livingEntity, class_1282 damageSource) {
        float f;
        class_1937 level = this.method_73183();
        if (this.firedFromWeapon != null && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            f = class_1890.method_60175((class_3218)serverLevel, (class_1799)this.firedFromWeapon, (class_1297)livingEntity, (class_1282)damageSource, (float)0.0f);
        } else {
            f = 0.0f;
        }
        double d = f;
        if (d > 0.0) {
            double e = Math.max(0.0, 1.0 - livingEntity.method_45325(class_5134.field_23718));
            class_243 vec3 = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021(d * 0.6 * e);
            if (vec3.method_1027() > 0.0) {
                livingEntity.method_5762(vec3.field_1352, 0.1, vec3.field_1350);
            }
        }
    }

    public void setPickupStatus(PickupStatus i) {
        this.pickupStatus = i;
    }

    public PickupStatus getPickupStatus() {
        return this.pickupStatus;
    }

    public boolean canPickup(class_1657 entityplayer) {
        if (this.pickupStatus == PickupStatus.ALLOWED) {
            return true;
        }
        if (this.pickupStatus == PickupStatus.CREATIVE_ONLY) {
            return entityplayer.method_68878();
        }
        return this.pickupStatus == PickupStatus.OWNER_ONLY && entityplayer.equals((Object)this.method_24921());
    }

    public void method_5694(@NotNull class_1657 entityplayer) {
        if (this.inGround && this.field_7574 <= 0 && this.canPickup(entityplayer) && !this.method_73183().method_8608()) {
            class_1799 item = this.method_7445();
            if (item.method_7960()) {
                return;
            }
            if (this.pickupStatus == PickupStatus.CREATIVE_ONLY && entityplayer.method_68878() || entityplayer.method_31548().method_7394(item)) {
                this.method_5783(class_3417.field_15197, 0.2f, ((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    protected void onItemPickup(class_1657 entityplayer) {
        entityplayer.method_6103((class_1297)this, 1);
    }

    @Nullable
    public class_1799 method_59958() {
        return this.firedFromWeapon;
    }

    protected void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71465("xTile", this.xTile);
        valueOutput.method_71465("yTile", this.yTile);
        valueOutput.method_71465("zTile", this.zTile);
        if (this.inBlockState != null) {
            valueOutput.method_71468("inBlockState", class_2680.field_24734, (Object)this.inBlockState);
        }
        valueOutput.method_71462("shake", (byte)this.field_7574);
        valueOutput.method_71472("inGround", this.inGround);
        valueOutput.method_71472("beenInGround", this.beenInGround);
        valueOutput.method_71462("pickup", (byte)this.pickupStatus.ordinal());
        if (this.firedFromWeapon != null) {
            valueOutput.method_71468("weapon", class_1799.field_24671, (Object)this.firedFromWeapon);
        }
    }

    protected void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.xTile = valueInput.method_71424("xTile", (int)this.method_23317());
        this.yTile = valueInput.method_71424("yTile", (int)this.method_23318());
        this.zTile = valueInput.method_71424("zTile", (int)this.method_23321());
        this.inBlockState = valueInput.method_71426("inBlockState", class_2680.field_24734).orElse(null);
        this.field_7574 = valueInput.method_71421("shake", (byte)0) & 0xFF;
        this.inGround = valueInput.method_71433("inGround", false);
        this.beenInGround = valueInput.method_71433("beenInGround", false);
        this.pickupStatus = valueInput.method_71426("pickup", PickupStatus.CODEC).orElse(PickupStatus.DISALLOWED);
        this.firedFromWeapon = valueInput.method_71426("weapon", class_1799.field_24671).orElse(null);
    }

    public static enum PickupStatus {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY,
        OWNER_ONLY;

        public static final Codec<PickupStatus> CODEC;

        public static PickupStatus getByOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }

        static {
            CODEC = Codec.BYTE.xmap(PickupStatus::getByOrdinal, status -> (byte)status.ordinal());
        }
    }
}

