/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.entity.EntityCannon;
import ckathode.weaponmod.item.ExtendedReachHelper;
import ckathode.weaponmod.item.IExtendedReachItem;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.RangedComponent;
import ckathode.weaponmod.network.MsgCannonFire;
import ckathode.weaponmod.network.WMMessagePipeline;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class WMClientEventHandler {
    @Nullable
    private static IExtendedReachItem getExtendedReachItem(ItemStack itemstack) {
        IItemWeapon iiw;
        Object object = itemstack.getItem();
        if (object instanceof IExtendedReachItem) {
            IExtendedReachItem ieri = (IExtendedReachItem)object;
            return ieri;
        }
        object = itemstack.getItem();
        if (object instanceof IItemWeapon && (object = (iiw = (IItemWeapon)object).getMeleeComponent()) instanceof IExtendedReachItem) {
            IExtendedReachItem ieri = (IExtendedReachItem)object;
            return ieri;
        }
        return null;
    }

    public static EventResult onMouseClick(Minecraft client, int button, int action, int mods) {
        IExtendedReachItem ieri;
        ItemStack itemstack;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !player.level().isClientSide || Minecraft.getInstance().screen != null) {
            return EventResult.pass();
        }
        if (button == 0 && action == 1 && !(itemstack = player.getMainHandItem()).isEmpty() && (ieri = WMClientEventHandler.getExtendedReachItem(itemstack)) != null) {
            float reach = ieri.getExtendedReach(player.level(), (LivingEntity)player, itemstack);
            HitResult raytraceResult = ExtendedReachHelper.getMouseOver(0.0f, reach);
            if (!(raytraceResult instanceof EntityHitResult)) {
                return EventResult.pass();
            }
            EntityHitResult ertr = (EntityHitResult)raytraceResult;
            Entity entity = ertr.getEntity();
            if (entity != player && entity.invulnerableTime == 0) {
                Minecraft.getInstance().gameMode.attack((Player)player, entity);
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }

    public static void onPlayerTick(Player player) {
        if (!player.level().isClientSide) {
            return;
        }
        if (player instanceof LocalPlayer) {
            EntityCannon cannon;
            Entity entity;
            LocalPlayer entity2 = (LocalPlayer)player;
            if (entity2.input.keyPresses.jump() && (entity = entity2.getVehicle()) instanceof EntityCannon && (cannon = (EntityCannon)entity).isLoaded()) {
                MsgCannonFire msg = new MsgCannonFire(cannon);
                WMMessagePipeline.sendToServer(msg);
            }
        }
    }

    public static float getNewFOV(LivingEntity entity, float fov, float newFov) {
        IItemWeapon iiw;
        RangedComponent rc;
        Item item;
        if (entity.isUsingItem() && (item = entity.getUseItem().getItem()) instanceof IItemWeapon && (rc = (iiw = (IItemWeapon)item).getRangedComponent()) != null && RangedComponent.isReadyToFire(entity.getUseItem())) {
            return fov * rc.getFOVMultiplier(entity.getTicksUsingItem());
        }
        return newFov;
    }

    public static void init() {
        if (Platform.getEnvironment() != Env.CLIENT) {
            return;
        }
        TickEvent.PLAYER_PRE.register(WMClientEventHandler::onPlayerTick);
        ClientRawInputEvent.MOUSE_CLICKED_PRE.register(WMClientEventHandler::onMouseClick);
    }
}

