/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WMDamageSources;
import ckathode.weaponmod.WMRegistries;
import ckathode.weaponmod.entity.projectile.EntityMaterialProjectile;
import ckathode.weaponmod.item.ItemFlail;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityFlail
extends EntityMaterialProjectile<EntityFlail> {
    public static final String ID = "flail";
    public static final EntityType<EntityFlail> TYPE = WMRegistries.createEntityType("flail", EntityDimensions.fixed((float)0.5f, (float)0.5f).withEyeHeight(0.0f), EntityFlail::new);
    public boolean isSwinging;
    private float flailDamage = 1.0f;
    private Vec3 distance = Vec3.ZERO;

    public EntityFlail(EntityType<EntityFlail> entityType, Level world) {
        super(entityType, world);
    }

    public EntityFlail(Level world, double d, double d1, double d2, @Nullable ItemStack firedFromWeapon) {
        super(TYPE, world, firedFromWeapon);
        this.setPos(d, d1, d2);
    }

    public EntityFlail(Level worldIn, LivingEntity shooter, ItemStack itemstack) {
        this(worldIn, shooter.getX(), shooter.getEyeY() - 0.3, shooter.getZ(), itemstack);
        this.setOwner((Entity)shooter);
        this.setPickupStatusFromEntity(shooter);
        this.setThrownItemStack(itemstack);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)serverEntity);
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        Vec3 entityMotion = entity.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(entityMotion.x, entity.onGround() ? 0.0 : entityMotion.y, entityMotion.z));
        this.swing(f, f1, f3, f4);
    }

    @Override
    public void tick() {
        super.tick();
        Entity shooter = this.getOwner();
        if (shooter != null) {
            this.distance = shooter.position().subtract(this.position());
            if (this.distance.lengthSqr() > 9.0) {
                this.returnToOwner(true);
            }
            if (shooter instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)shooter;
                ItemStack itemstack = livingEntity.getMainHandItem();
                ItemStack thrownItem = this.getWeapon();
                if (itemstack.isEmpty() || !thrownItem.isEmpty() && itemstack.getItem() != thrownItem.getItem() || !shooter.isAlive()) {
                    this.pickUpByOwner();
                }
            }
        } else if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.inGround) {
            this.inGround = false;
            return;
        }
        this.returnToOwner(false);
    }

    public void returnToOwner(boolean looseFromGround) {
        Entity shooter;
        if (looseFromGround) {
            this.inGround = false;
        }
        if ((shooter = this.getOwner()) == null) {
            return;
        }
        double targetPosX = shooter.getX();
        double targetPosY = shooter.getBoundingBox().minY + (double)0.4f;
        double targetPosZ = shooter.getZ();
        float f = 27.0f;
        float f2 = 2.0f;
        this.distance = new Vec3(targetPosX += -Math.sin((shooter.getYRot() + f) * ((float)Math.PI / 180)) * Math.cos(shooter.getXRot() * ((float)Math.PI / 180)) * (double)f2, targetPosY, targetPosZ += Math.cos((shooter.getYRot() + f) * ((float)Math.PI / 180)) * Math.cos(shooter.getXRot() * ((float)Math.PI / 180)) * (double)f2).subtract(this.position());
        double distanceTotalSqr = this.distance.lengthSqr();
        if (distanceTotalSqr > 9.0) {
            this.setPos(targetPosX, targetPosY, targetPosZ);
        } else if (distanceTotalSqr > 6.25) {
            this.isSwinging = false;
            this.setDeltaMovement(this.getDeltaMovement().scale(-0.5));
        }
        if (!this.isSwinging) {
            float f3 = 0.2f;
            this.setDeltaMovement(this.distance.scale((double)f3 * Math.sqrt(distanceTotalSqr)));
        }
    }

    public void pickUpByOwner() {
        this.remove(Entity.RemovalReason.DISCARDED);
        Entity shooter = this.getOwner();
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (!this.getWeapon().isEmpty()) {
                PlayerWeaponData.setFlailThrown(player, false);
            }
        }
    }

    public void swing(float f, float f1, float f2, float f3) {
        if (this.isSwinging) {
            return;
        }
        this.playSound(SoundEvents.ARROW_SHOOT, 0.5f, 0.4f / (this.random.nextFloat() * 0.4f + 0.8f));
        float x = -Mth.sin((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float y = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(f1 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        this.shoot(x, y, z, f2, f3);
        this.isSwinging = true;
        this.inGround = false;
    }

    @Override
    @NotNull
    public DamageSource getDamageSource() {
        DamageSource damageSource;
        Entity shooter = this.getDamagingEntity();
        if (shooter instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)shooter;
            damageSource = this.damageSources().mobAttack(livingEntity);
        } else {
            damageSource = this.damageSources().source(WMDamageSources.WEAPON, (Entity)this, shooter);
        }
        return damageSource;
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity.equals((Object)this.getOwner())) {
            return;
        }
        if (entity.hurtOrSimulate(this.getDamageSource(), this.flailDamage + this.extraDamage)) {
            this.playHitSound();
            this.returnToOwner(true);
        } else {
            this.bounceBack();
        }
    }

    @Override
    public void bounceBack() {
        this.setDeltaMovement(this.getDeltaMovement().scale(-0.8));
        this.setYRot(this.getYRot() + 180.0f);
        this.yRotO += 180.0f;
        this.ticksInAir = 0;
    }

    @Override
    public void playHitSound() {
        if (this.inGround) {
            return;
        }
        this.playSound(SoundEvents.PLAYER_HURT, 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
    }

    @Override
    public void setThrownItemStack(@NotNull ItemStack itemstack) {
        if (itemstack.isEmpty() || itemstack.getItem() instanceof ItemFlail) {
            super.setThrownItemStack(itemstack);
            Item item = itemstack.getItem();
            if (item instanceof ItemFlail) {
                ItemFlail flail = (ItemFlail)item;
                this.flailDamage = flail.getFlailDamage();
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putFloat("fDmg", this.flailDamage);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.flailDamage = valueInput.getFloatOr("fDmg", 1.0f);
    }

    @Override
    public void playerTouch(@NotNull Player entityplayer) {
    }

    @Override
    public int getMaxArrowShake() {
        return 0;
    }

    @Override
    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)WMRegistries.ITEM_FLAIL_WOOD.get());
    }
}

