package net.litetex.rpf.mixin;

import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@SuppressWarnings("checkstyle:MagicNumber")
@Mixin(class_1408.class)
public abstract class EntityNavigationMixin
{
	@Unique
	private static final double DEFAULT_NODE_TIMEOUT = 200.0;
	@Unique
	private static final double MAX_NODE_TIMEOUT = 4000.0;
	
	/**
	 * Ensures that navigation can never be executed for an infinite time.
	 * <p>
	 * Ensured by setting currentNodeTimeout to a higher value then 0 when there is no movement.
	 * </p>
	 *
	 * @see #resetNodeBreakInfinite(CallbackInfo)
	 */
	@Inject(
		method = "checkTimeouts",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/ai/pathing/Path;getCurrentNodePos()Lnet/minecraft/util/math/BlockPos;"),
		cancellable = true
	)
	public void checkTimeoutsBreakInfinite(final class_243 currentPos, final CallbackInfo ci)
	{
		final class_2382 vec3i = this.currentPath.method_31032();
		final long currentWorldTime = this.world.method_8510();
		if(vec3i.equals(this.lastNodePosition))
		{
			this.currentNodeMs = this.currentNodeMs + (currentWorldTime - this.lastActiveTickMs);
		}
		else
		{
			this.lastNodePosition = vec3i;
			final float movementSpeed = this.entity.method_6029();
			this.currentNodeTimeout = movementSpeed > 0.0F
				? Math.min(
				currentPos.method_1022(class_243.method_24955(this.lastNodePosition)) / movementSpeed * 20.0,
				MAX_NODE_TIMEOUT) // Set a max timeout to handle situations where movement speed is near zero
				: DEFAULT_NODE_TIMEOUT; // Always set a timeout > 0 when speed is 0
		}
		
		// Ignore currentNodeTimeout != 0
		if(this.currentNodeMs > this.currentNodeTimeout * 3.0)
		{
			this.resetNodeAndStop();
		}
		
		this.lastActiveTickMs = currentWorldTime;
		
		ci.cancel();
	}
	
	@Inject(
		method = "resetNode",
		at = @At("TAIL")
	)
	public void resetNodeBreakInfinite(final CallbackInfo ci)
	{
		this.currentNodeTimeout = DEFAULT_NODE_TIMEOUT;
	}
	
	@Shadow
	@Final
	protected class_1308 entity;
	
	@Shadow
	@Nullable
	protected class_11 currentPath;
	
	@Shadow
	@Final
	protected class_1937 world;
	
	@Shadow
	protected class_2382 lastNodePosition;
	
	@Shadow
	protected long currentNodeMs;
	
	@Shadow
	protected long lastActiveTickMs;
	
	@Shadow
	protected double currentNodeTimeout;
	
	@Shadow
	protected abstract void resetNodeAndStop();
}
