package net.litetex.rpf.mixin;

import net.minecraft.class_1314;
import net.minecraft.class_1367;
import net.minecraft.class_1408;
import net.minecraft.class_1463;
import net.minecraft.class_2246;
import net.minecraft.class_2271;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;


@SuppressWarnings("checkstyle:MagicNumber")
@Mixin(class_1463.class_1470.class)
public abstract class RabbitEntityEatCarrotCropGoalMixin extends class_1367
{
	// region Move into carrots to eat
	
	/**
	 * A rabbits needs to be inside the carrots to be able to eat them!
	 */
	@Override
	protected void method_6290()
	{
		final class_1408 nav = this.field_6516.method_5942();
		nav.method_6334(
			nav.method_6352(
				this.field_6512.method_10263() + 0.5,
				this.field_6512.method_10264() + 1.0,
				this.field_6512.method_10260() + 0.5,
				1),
			this.field_6514);
	}
	
	/**
	 * Same code fix as {@link #method_6290()} above
	 */
	@Redirect(
		method = "tick",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/ai/goal/MoveToTargetPosGoal;tick()V")
	)
	public void tickSuperRedirect(final class_1367 instance)
	{
		final class_2338 blockPos = this.method_30953();
		if(!blockPos.method_19769(this.field_6516.method_19538(), this.method_6291()))
		{
			this.field_6513 = false;
			this.field_6517++;
			if(this.method_6294())
			{
				// Call fixed method
				this.method_6290();
			}
		}
		else
		{
			this.field_6513 = true;
			this.field_6517--;
		}
	}
	
	// endregion
	
	// region Eat when inside crops and not when moving/jumping
	
	@Unique
	protected int reachedButIsJumpingTicks;
	
	@Inject(
		method = "tick",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/util/math/BlockPos;up()Lnet/minecraft/util/math/BlockPos;"
		),
		cancellable = true
	)
	public void tickWaitUntilRabbitHasCompletedJump(final CallbackInfo ci)
	{
		// Stop navigation during first execution
		if(this.reachedButIsJumpingTicks == 0)
		{
			this.field_6516.method_5942().method_6340();
		}
		
		// If the rabbit is still jumping and timeout is NOT reached, wait for the jump to be completed
		// -> Abort further method execution
		if(this.rabbit.field_6282 && this.reachedButIsJumpingTicks < 100)
		{
			this.reachedButIsJumpingTicks++;
			ci.cancel();
			return;
		}
		
		// Otherwise reset
		this.reachedButIsJumpingTicks = 0;
		
		// And execute the upstream code now
	}
	
	// endregion
	
	/**
	 * isTargetPos always returns <code>false</code> when called by {@link #method_6266()}. <br/> Even when there
	 * would be a valid target due to checking for <code>!hasTarget</code>. <br/>
	 * <code>hasTarget</code> is always set to <code>true</code> at this point, exiting the method with
	 * <code>false</code>.
	 */
	@Inject(
		method = "isTargetPos",
		at = @At("HEAD"),
		cancellable = true
	)
	public void isTargetPosDoNotAbortWhenHavingTarget(
		final class_4538 world,
		final class_2338 pos,
		final CallbackInfoReturnable<Boolean> cir)
	{
		if(!this.wantsCarrots)
		{
			cir.setReturnValue(false);
			return;
		}
		
		class_2680 blockState = world.method_8320(pos);
		if(blockState.method_27852(class_2246.field_10362))
		{
			blockState = world.method_8320(pos.method_10084());
			if(blockState.method_26204() instanceof final class_2271 carrotsBlock && carrotsBlock.method_9825(blockState))
			{
				cir.setReturnValue(true);
				return;
			}
		}
		
		cir.setReturnValue(false);
	}
	
	/**
	 * Set <code>hasTarget</code> in correct method
	 */
	@Override
	protected boolean method_6292()
	{
		final boolean foundTarget = super.method_6292();
		this.hasTarget = foundTarget;
		return foundTarget;
	}
	
	protected RabbitEntityEatCarrotCropGoalMixin(
		final class_1314 mob,
		final double speed,
		final int range)
	{
		super(mob, speed, range);
	}
	
	@Shadow
	private boolean wantsCarrots;
	
	@Shadow
	private boolean hasTarget;
	
	@Shadow
	@Final
	private class_1463 rabbit;
}
