package net.litetex.rpf.mixin;

import net.minecraft.class_11;
import net.minecraft.class_1376;
import net.minecraft.class_1463;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;


@SuppressWarnings("checkstyle:MagicNumber")
@Mixin(class_1463.class)
public abstract class RabbitEntityMixin extends RabbitEntity_MobEntityMixin
{
	/**
	 * Fixes that rabbits jumping too low when doing the WanderAroundFarGoal.
	 * <p>
	 * Also improves the performance by not doing redundant checks.
	 * </p>
	 */
	@Inject(
		method = "getJumpVelocity",
		at = @At("HEAD"),
		cancellable = true)
	public void getJumpVelocityOptimized(final CallbackInfoReturnable<Float> cir)
	{
		final float f;
		if(this.horizontalCollision
			|| this.moveControl.method_6241()
			&& this.isYRequiringJump(this.moveControl.method_6235()))
		{
			f = 0.5F;
		}
		else
		{
			final class_11 path = this.navigation.method_6345();
			if(path != null
				&& !path.method_46()
				&& this.isYRequiringJump(path.method_49(this.self()).field_1351))
			{
				f = 0.5F;
			}
			else
			{
				f = this.moveControl.method_6242() <= 0.6 ? 0.2F : 0.3F;
			}
		}
		
		cir.setReturnValue(f + this.getJumpBoostVelocityModifier());
	}
	
	@Unique
	protected boolean isYRequiringJump(final double targetY)
	{
		return targetY > this.getY() + 0.5;
	}
	
	@SuppressWarnings("javabugs:S6320")
	@Unique
	protected class_1463 self()
	{
		return (class_1463)(Object)this;
	}
	
	/**
	 * By default, if a rabbit "is idle" it will always do the WanderAroundFarGoal as there is nothing else to do.
	 * <p>
	 * This introduces an additional LookAroundGoal - that is in nearly all other passive entities (cows,chickens,...)
	 * but somehow missing in rabbits.
	 * </p>
	 */
	@Inject(
		method = "initGoals",
		at = @At("TAIL"))
	protected void initGoalsAddLookAroundGoal(final CallbackInfo ci)
	{
		this.goalSelector.method_6277(12, new class_1376(this.self()));
	}
}
