package net.litetex.rpf.mixin;

import net.minecraft.class_1335;
import net.minecraft.class_1463;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(class_1463.class_1468.class)
public abstract class RabbitEntityRabbitMoveControlMixin extends class_1335
{
	/**
	 * This patches the tick method to also enforce a non-zero speed when a rabbit is jumping.
	 * <p>
	 * This way rabbits cannot "stall" (no horizontal movement) when jumping
	 * </p>
	 */
	@Inject(
		method = "tick",
		at = @At(value = "HEAD"),
		cancellable = true)
	public void tickRespectJumping(final CallbackInfo ci)
	{
		// This is required so that rabbits are not "gliding" over the floor
		if(this.rabbit.method_24828()
			&& !this.rabbit.field_6282
			&& !((class_1463.class_5197)this.rabbit.field_6204).method_27312())
		{
			this.setSpeedToRabbit(0.0);
		}
		else if(this.method_6241()
			// Change the speed when the rabbit is jumping to prevent "stalling"
			|| this.field_6374 == class_1335.class_1336.field_6379)
		{
			this.setSpeedToRabbit(this.rabbitSpeed);
		}
		
		super.method_6240();
		
		ci.cancel();
	}
	
	@Unique
	protected void setSpeedToRabbit(final double speed)
	{
		// Only set it if it's not already set!
		// The setSpeed method is otherwise constantly fired which also internally executes moveControl.moveTo
		// and thus the rabbit tries to move to the last selected target even when it's current goal
		// (e.g. WanderAround) has been stopped
		if(this.rabbit.method_5942().field_6668 != speed)
		{
			this.rabbit.method_6606(speed);
		}
	}
	
	protected RabbitEntityRabbitMoveControlMixin(final class_1463 owner)
	{
		super(owner);
	}
	
	@Shadow
	@Final
	private class_1463 rabbit;
	
	@Shadow
	private double rabbitSpeed;
}
