/*
 * Decompiled with CFR 0.152.
 */
package net.withrage.simpleexcavators.item.custom;

import java.util.HashSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.withrage.simpleexcavators.item.custom.ExcavatorMiningContext;

public class ExcavatorItem
extends class_1766 {
    public ExcavatorItem(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super((float)attackDamage, attackSpeed, material, class_3481.field_33716, settings);
    }

    private static class_2350 fallbackFace(class_1657 p) {
        float pitch = p.method_36455();
        if (pitch > 60.0f) {
            return class_2350.field_11033;
        }
        if (pitch < -60.0f) {
            return class_2350.field_11036;
        }
        return p.method_5735();
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        boolean result = super.method_7879(stack, world, state, pos, miner);
        if (!world.field_9236 && miner instanceof class_1657) {
            class_1657 player = (class_1657)miner;
            if (!state.method_26164(class_3481.field_33716)) {
                return result;
            }
            if (player.method_5715()) {
                return result;
            }
            class_2350 hitFace = ExcavatorMiningContext.consumeLastHitFace(player);
            if (hitFace == null) {
                hitFace = ExcavatorItem.fallbackFace(player);
            }
            this.breakExtraBlocksAround(pos, world, player, stack, state, hitFace);
        }
        return result;
    }

    private void breakExtraBlocksAround(class_2338 origin, class_1937 world, class_1657 player, class_1799 excavatorStack, class_2680 originState, class_2350 hitFace) {
        Plane plane = this.getPlaneFromHitFace(hitFace);
        HashSet<class_2338> targets = new HashSet<class_2338>();
        for (int ox = -1; ox <= 1; ++ox) {
            for (int oy = -1; oy <= 1; ++oy) {
                for (int oz = -1; oz <= 1; ++oz) {
                    if (ox == 0 && oy == 0 && oz == 0 || !plane.allowsOffset(ox, oy, oz)) continue;
                    targets.add(origin.method_10069(ox, oy, oz));
                }
            }
        }
        for (class_2338 targetPos : targets) {
            this.breakOneExtraBlock(world, player, excavatorStack, origin, originState, targetPos);
        }
    }

    private void breakOneExtraBlock(class_1937 world, class_1657 player, class_1799 excavatorStack, class_2338 originPos, class_2680 originState, class_2338 targetPos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2680 targetState = world.method_8320(targetPos);
        if (targetState.method_26215() || targetState.method_26214((class_1922)world, targetPos) < 0.0f) {
            return;
        }
        if (!targetState.method_26164(class_3481.field_33716)) {
            return;
        }
        if (!excavatorStack.method_7951(targetState)) {
            return;
        }
        if (!player.method_7305(targetState)) {
            return;
        }
        float originHardness = originState.method_26214((class_1922)world, originPos);
        float targetHardness = targetState.method_26214((class_1922)world, targetPos);
        if (targetHardness < 0.0f) {
            return;
        }
        if (originHardness >= 0.0f && targetHardness > originHardness + 0.5f) {
            return;
        }
        boolean creative = player.method_7337();
        if (!creative) {
            excavatorStack.method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5808));
        }
        world.method_8651(targetPos, false, (class_1297)player);
        class_2248.method_9511((class_2680)targetState, (class_1937)serverWorld, (class_2338)targetPos, (class_2586)world.method_8321(targetPos), (class_1297)player, (class_1799)excavatorStack);
        world.method_8652(targetPos, class_2246.field_10124.method_9564(), 3);
    }

    private Plane getPlaneFromHitFace(class_2350 face) {
        if (face == null) {
            return Plane.HORIZONTAL;
        }
        switch (face) {
            case field_11036: 
            case field_11033: {
                return Plane.HORIZONTAL;
            }
            case field_11043: 
            case field_11035: {
                return Plane.VERTICAL_YX;
            }
            case field_11034: 
            case field_11039: {
                return Plane.VERTICAL_YZ;
            }
        }
        return Plane.HORIZONTAL;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Plane {
        HORIZONTAL{

            @Override
            public boolean allowsOffset(int ox, int oy, int oz) {
                return oy == 0 && (ox != 0 || oz != 0);
            }
        }
        ,
        VERTICAL_YX{

            @Override
            public boolean allowsOffset(int ox, int oy, int oz) {
                return oz == 0 && (ox != 0 || oy != 0);
            }
        }
        ,
        VERTICAL_YZ{

            @Override
            public boolean allowsOffset(int ox, int oy, int oz) {
                return ox == 0 && (oy != 0 || oz != 0);
            }
        };


        public abstract boolean allowsOffset(int var1, int var2, int var3);
    }
}

