/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.modds.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.modds.init.FirstModModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class FirstModModBiomes {
    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry dimensionTypeRegistry = server.registryAccess().lookupOrThrow(Registries.DIMENSION_TYPE);
        Registry levelStemTypeRegistry = server.registryAccess().lookupOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().lookupOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            NoiseGeneratorSettings moddedNoiseGeneratorSettings;
            ArrayList<SurfaceRules.RuleSource> surfaceRules;
            SurfaceRules.SequenceRuleSource sequenceRuleSource;
            SurfaceRules.RuleSource currentRuleSource;
            BiomeSource noiseGeneratorSettings;
            NoiseBasedChunkGenerator noiseGenerator;
            ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters;
            MultiNoiseBiomeSource noiseSource;
            ChunkGenerator chunkGenerator;
            DimensionType dimensionType = (DimensionType)levelStem.type().value();
            if (dimensionType == dimensionTypeRegistry.getOrThrow(BuiltinDimensionTypes.OVERWORLD).getDelegate().value()) {
                chunkGenerator = levelStem.generator();
                BiomeSource biomeSource = chunkGenerator.getBiomeSource();
                if (biomeSource instanceof MultiNoiseBiomeSource) {
                    noiseSource = (MultiNoiseBiomeSource)biomeSource;
                    parameters = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>(noiseSource.parameters().values());
                    FirstModModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"first_mod", (String)"honnyfileds")))));
                    FirstModModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"first_mod", (String)"honnyfileds")))));
                    FirstModModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.2f, (float)0.9f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"first_mod", (String)"emeraledtaverns")))));
                    chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
                    chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
                }
                if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                    noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                    noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.settings.value();
                    currentRuleSource = noiseGeneratorSettings.surfaceRule();
                    if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
                        sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                        surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.sequence());
                        FirstModModBiomes.addSurfaceRule(surfaceRules, 1, FirstModModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"first_mod", (String)"emeraledtaverns")), Blocks.EMERALD_ORE.defaultBlockState(), Blocks.EMERALD_ORE.defaultBlockState(), Blocks.EMERALD_ORE.defaultBlockState()));
                        FirstModModBiomes.addSurfaceRule(surfaceRules, 1, FirstModModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"first_mod", (String)"honnyfileds")), Blocks.HONEYCOMB_BLOCK.defaultBlockState(), Blocks.HONEYCOMB_BLOCK.defaultBlockState(), Blocks.HONEY_BLOCK.defaultBlockState()));
                        moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.noiseSettings(), noiseGeneratorSettings.defaultBlock(), noiseGeneratorSettings.defaultFluid(), noiseGeneratorSettings.noiseRouter(), SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.spawnTarget(), noiseGeneratorSettings.seaLevel(), noiseGeneratorSettings.disableMobGeneration(), noiseGeneratorSettings.aquifersEnabled(), noiseGeneratorSettings.oreVeinsEnabled(), noiseGeneratorSettings.useLegacyRandomSource());
                        noiseGenerator.settings = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
                    }
                }
            }
            if (dimensionType != dimensionTypeRegistry.getOrThrow(BuiltinDimensionTypes.NETHER).getDelegate().value()) continue;
            chunkGenerator = levelStem.generator();
            noiseGeneratorSettings = chunkGenerator.getBiomeSource();
            if (noiseGeneratorSettings instanceof MultiNoiseBiomeSource) {
                noiseSource = (MultiNoiseBiomeSource)noiseGeneratorSettings;
                parameters = new ArrayList(noiseSource.parameters().values());
                FirstModModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"first_mod", (String)"netherplains")))));
                FirstModModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"first_mod", (String)"netherplains")))));
                chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
                chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.settings.value();
            currentRuleSource = noiseGeneratorSettings.surfaceRule();
            if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
            sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            surfaceRules = new ArrayList(sequenceRuleSource.sequence());
            FirstModModBiomes.addSurfaceRule(surfaceRules, 2, FirstModModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"first_mod", (String)"netherplains")), ((Block)FirstModModBlocks.NETHERGRASS.get()).defaultBlockState(), ((Block)FirstModModBlocks.NETHERGRASS.get()).defaultBlockState(), ((Block)FirstModModBlocks.NETHERGRASS.get()).defaultBlockState()));
            moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.noiseSettings(), noiseGeneratorSettings.defaultBlock(), noiseGeneratorSettings.defaultFluid(), noiseGeneratorSettings.noiseRouter(), SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.spawnTarget(), noiseGeneratorSettings.seaLevel(), noiseGeneratorSettings.disableMobGeneration(), noiseGeneratorSettings.aquifersEnabled(), noiseGeneratorSettings.oreVeinsEnabled(), noiseGeneratorSettings.useLegacyRandomSource());
            noiseGenerator.settings = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
        }
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))})));
    }

    private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))}));
    }

    private static void addParameterPoint(List<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters, Pair<Climate.ParameterPoint, Holder<Biome>> point) {
        if (!parameters.contains(point)) {
            parameters.add(point);
        }
    }

    private static void addSurfaceRule(List<SurfaceRules.RuleSource> surfaceRules, int index, SurfaceRules.RuleSource rule) {
        if (!surfaceRules.contains(rule)) {
            if (index >= surfaceRules.size()) {
                surfaceRules.add(rule);
            } else {
                surfaceRules.add(index, rule);
            }
        }
    }
}

