#version 330 compatibility

#include "settings.glsl"

uniform sampler2D colortex0;

in vec2 texcoord;

layout(location = 0) out vec4 color;

void main() {
    // 1. Get the screen color
    vec3 sceneColor = texture(colortex0, texcoord).rgb;

    // 2. LOGIC: Calculate Luminance (Human perception of brightness)
    // This is the exact same logic from your first shader.
    float luminance = dot(sceneColor, vec3(0.2125, 0.7154, 0.0721));
    vec3 grayscale = vec3(luminance);

    // 3. MODIFIED: Apply the slider
    // We must convert the 0-100 range into a useful multiplier.
    // Dividing by 50.0 makes 50 -> 1.0 (normal), 0 -> 0.0 (grayscale), 100 -> 2.0 (vibrant).
    float saturationAmount = SATURATION / 50.0;
    sceneColor = mix(grayscale, sceneColor, saturationAmount);

    // 4. Output result
    color = vec4(sceneColor, 1.0);
}
