/*
 * Decompiled with CFR 0.152.
 */
package me.white.justutils.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.white.justutils.JustUtils;
import me.white.justutils.editor.Editor;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

public class FunctionArgumentType
implements ArgumentType<String> {
    public static final SimpleCommandExceptionType NO_SUCH_FUNCTION_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.function.error.nosuchfunction"));

    public String parse(StringReader reader) throws CommandSyntaxException {
        String name;
        if (JustUtils.editor == null) {
            throw Editor.NOT_IN_EDITOR_EXCEPTION.createWithContext((ImmutableStringReader)reader);
        }
        Set functionNames = JustUtils.editor.getFunctions().keySet();
        if (!functionNames.contains(name = reader.getRemaining())) {
            throw NO_SUCH_FUNCTION_EXCEPTION.createWithContext((ImmutableStringReader)reader);
        }
        reader.setCursor(reader.getTotalLength());
        return name;
    }

    public static FunctionArgumentType function() {
        return new FunctionArgumentType();
    }

    public static String getFunctionArgument(CommandContext<FabricClientCommandSource> context, String key) {
        return (String)context.getArgument(key, String.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (JustUtils.editor == null) {
            return builder.buildFuture();
        }
        String remaining = builder.getRemaining();
        Set functionNames = JustUtils.editor.getFunctions().keySet();
        for (String name : functionNames) {
            if (!name.toLowerCase(Locale.ROOT).contains(remaining.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(name);
        }
        return builder.buildFuture();
    }
}

