/*
 * Decompiled with CFR 0.152.
 */
package me.white.justutils.commands;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.white.justutils.JustUtils;
import me.white.justutils.argument.EventArgumentType;
import me.white.justutils.argument.FunctionArgumentType;
import me.white.justutils.editor.Editor;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7157;

public class SearchCommand {
    public static final CommandSyntaxException NOT_FOUND_DEFINITION_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.search.error.notfounddefinition")).create();
    public static final CommandSyntaxException NOT_FOUND_USAGE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.search.error.notfoundusage")).create();
    public static final CommandSyntaxException NO_UNUSED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.search.error.nounused")).create();
    public static final CommandSyntaxException NOT_FOUND_EVENTS_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.search.error.notfoundevents")).create();
    public static final CommandSyntaxException NO_INVALID_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.search.error.noinvalid")).create();
    private static final String OUTPUT_SUCCESS = "commands.search.success";
    private static final String OUTPUT_MULTIPLE = "commands.search.multiple";
    private static final String OUTPUT_UNUSED = "commands.search.unused";
    private static final String OUTPUT_EVENT_SUCCESS = "commands.search.eventsuccess";
    private static final String OUTPUT_EVENT_MULTIPLE = "commands.search.eventmultiple";
    private static final String OUTPUT_INVALID = "commands.search.invalid";

    private static Map<class_243, String> findCalls() {
        HashMap<class_243, String> calls = new HashMap<class_243, String>();
        class_638 world = class_310.method_1551().field_1687;
        int floor = 0;
        while (!world.method_8320(new class_2338(0, 4 + floor * 7, 0)).method_26215()) {
            for (int line = 0; line < 23; ++line) {
                if (world.method_8320(new class_2338(4, 5 + floor * 7, 4)).method_26215()) {
                    System.out.printf("Skipping %s %s\n", floor, line);
                    continue;
                }
                for (int block = 1; block < 44; ++block) {
                    class_2338 blockLoc = new class_2338(4 + block * 2, 5 + floor * 7, 4 + line * 4);
                    class_2680 blockState = world.method_8320(blockLoc);
                    if (!blockState.method_27852(class_2246.field_10090) && !blockState.method_27852(class_2246.field_10013)) continue;
                    class_2338 signLoc = blockLoc.method_10069(0, 0, 1);
                    class_243 pos = new class_243((double)block, (double)floor, (double)line);
                    Optional signOptional = world.method_35230(signLoc, class_2591.field_11911);
                    if (signOptional.isPresent()) {
                        String name = ((class_2625)signOptional.get()).method_49853().method_49859(1, false).getString();
                        System.out.printf("%s: %s\n", name, pos);
                        if (name == null || name.isEmpty() || name.contains("%")) continue;
                        calls.put(pos, name);
                        continue;
                    }
                    System.out.printf("Sign nonexistent: %s\n", pos);
                }
            }
            ++floor;
        }
        return calls;
    }

    private static List<class_243> findUsages(String name) {
        ArrayList<class_243> locs = new ArrayList<class_243>();
        class_638 world = class_310.method_1551().field_1687;
        int floor = 0;
        while (!world.method_8320(new class_2338(0, 4 + floor * 7, 0)).method_26215()) {
            for (int line = 0; line < 23; ++line) {
                if (world.method_8320(new class_2338(4, 5 + floor * 7, 4)).method_26215()) continue;
                for (int block = 1; block < 44; ++block) {
                    class_2338 blockLoc = new class_2338(4 + block * 2, 5 + floor * 7, 4 + line * 4);
                    class_2680 blockState = world.method_8320(blockLoc);
                    if (!blockState.method_27852(class_2246.field_10090) && !blockState.method_27852(class_2246.field_10013)) continue;
                    class_2338 signLoc = blockLoc.method_10069(0, 0, 1);
                    class_243 pos = new class_243((double)block, (double)floor, (double)line);
                    world.method_35230(signLoc, class_2591.field_11911).ifPresent(sign -> {
                        String query = sign.method_49853().method_49859(1, false).getString();
                        if (name.equals(query)) {
                            locs.add(pos);
                        }
                    });
                }
            }
            ++floor;
        }
        return locs;
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        LiteralCommandNode searchNode = ClientCommandManager.literal((String)"search").build();
        LiteralCommandNode searchDefinitionNode = ClientCommandManager.literal((String)"definition").build();
        ArgumentCommandNode searchDefinitionFunctionNode = ((RequiredArgumentBuilder)ClientCommandManager.argument((String)"function", (ArgumentType)FunctionArgumentType.function()).executes(context -> {
            if (JustUtils.editor == null) {
                throw Editor.NOT_IN_EDITOR_EXCEPTION.create();
            }
            String text = FunctionArgumentType.getFunctionArgument((CommandContext<FabricClientCommandSource>)context, "function");
            Multimap<String, class_243> functions = JustUtils.editor.getFunctions();
            List<class_243> definitions = functions.entries().stream().filter(entry -> ((String)entry.getKey()).equals(text)).map(Map.Entry::getValue).toList();
            if (definitions.isEmpty()) {
                throw NOT_FOUND_DEFINITION_EXCEPTION;
            }
            if (definitions.size() == 1) {
                class_243 simplifiedLoc = definitions.getFirst();
                JustUtils.tp(Editor.toRealLoc(simplifiedLoc));
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)OUTPUT_SUCCESS, (Object[])new Object[]{Editor.locText(simplifiedLoc)}));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)OUTPUT_MULTIPLE));
                for (class_243 loc : definitions) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(Editor.locText(loc));
                }
            }
            return 1;
        })).build();
        LiteralCommandNode searchUsageNode = ClientCommandManager.literal((String)"usage").build();
        ArgumentCommandNode searchUsageFunctionNode = ((RequiredArgumentBuilder)ClientCommandManager.argument((String)"function", (ArgumentType)FunctionArgumentType.function()).executes(context -> {
            if (JustUtils.editor == null) {
                throw Editor.NOT_IN_EDITOR_EXCEPTION.create();
            }
            String text = FunctionArgumentType.getFunctionArgument((CommandContext<FabricClientCommandSource>)context, "function");
            List<class_243> locs = SearchCommand.findUsages(text);
            if (locs.isEmpty()) {
                throw NOT_FOUND_USAGE_EXCEPTION;
            }
            if (locs.size() == 1) {
                class_243 simplifiedLoc = locs.getFirst();
                JustUtils.tp(Editor.toRealLoc(simplifiedLoc));
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)OUTPUT_SUCCESS, (Object[])new Object[]{Editor.locText(simplifiedLoc)}));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)OUTPUT_MULTIPLE));
                for (class_243 simplifiedLoc : locs) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(Editor.locText(simplifiedLoc));
                }
            }
            return 1;
        })).build();
        LiteralCommandNode searchUnusedNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"unused").executes(context -> {
            if (JustUtils.editor == null) {
                throw Editor.NOT_IN_EDITOR_EXCEPTION.create();
            }
            ArrayList<String> unused = new ArrayList<String>();
            Multimap<String, class_243> functions = JustUtils.editor.getFunctions();
            for (Map.Entry function : functions.entries()) {
                String string = (String)function.getKey();
                List<class_243> usages = SearchCommand.findUsages(string);
                if (!usages.isEmpty()) continue;
                unused.add(string);
            }
            if (unused.isEmpty()) {
                throw NO_UNUSED_EXCEPTION;
            }
            HashMap<String, class_243> unusedFunctions = new HashMap<String, class_243>();
            for (Map.Entry entry : functions.entries()) {
                if (!unused.contains(entry.getKey())) continue;
                unusedFunctions.put((String)entry.getKey(), (class_243)entry.getValue());
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)OUTPUT_UNUSED));
            for (Map.Entry entry : unusedFunctions.entrySet()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)((String)entry.getKey()))).method_10852((class_2561)class_2561.method_43470((String)": ").method_10862(class_2583.field_24360.method_10977(class_124.field_1063))).method_10852(Editor.locText((class_243)entry.getValue())));
            }
            return 1;
        })).build();
        LiteralCommandNode searchEventNode = ClientCommandManager.literal((String)"event").build();
        ArgumentCommandNode searchEventNameNode = ((RequiredArgumentBuilder)ClientCommandManager.argument((String)"name", (ArgumentType)EventArgumentType.event()).executes(context -> {
            if (JustUtils.editor == null) {
                throw Editor.NOT_IN_EDITOR_EXCEPTION.create();
            }
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            Multimap<String, class_243> events = JustUtils.editor.getEvents();
            List<class_243> locs = events.entries().stream().filter(event -> ((String)event.getKey()).equals(name)).map(Map.Entry::getValue).toList();
            if (locs.isEmpty()) {
                throw NOT_FOUND_EVENTS_EXCEPTION;
            }
            if (locs.size() == 1) {
                class_243 simplifiedLoc = locs.getFirst();
                JustUtils.tp(Editor.toRealLoc(simplifiedLoc));
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)OUTPUT_EVENT_SUCCESS, (Object[])new Object[]{Editor.locText(simplifiedLoc)}));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)OUTPUT_EVENT_MULTIPLE));
                for (class_243 simplifiedLoc : locs) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(Editor.locText(simplifiedLoc));
                }
            }
            return 1;
        })).build();
        LiteralCommandNode searchInvalidNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"invalid").executes(context -> {
            if (JustUtils.editor == null) {
                throw Editor.NOT_IN_EDITOR_EXCEPTION.create();
            }
            HashMap<class_243, String> invalid = new HashMap<class_243, String>();
            Multimap<String, class_243> functions = JustUtils.editor.getFunctions();
            for (Map.Entry<class_243, String> entry : SearchCommand.findCalls().entrySet()) {
                if (functions.containsKey((Object)entry.getValue())) continue;
                invalid.put(entry.getKey(), entry.getValue());
            }
            if (invalid.isEmpty()) {
                throw NO_INVALID_EXCEPTION;
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)OUTPUT_INVALID));
            for (Map.Entry<Object, String> entry : invalid.entrySet()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)entry.getValue())).method_10852((class_2561)class_2561.method_43470((String)": ").method_10862(class_2583.field_24360.method_10977(class_124.field_1063))).method_10852(Editor.locText((class_243)entry.getKey())));
            }
            return 1;
        })).build();
        searchNode.addChild((CommandNode)searchDefinitionNode);
        searchDefinitionNode.addChild((CommandNode)searchDefinitionFunctionNode);
        searchNode.addChild((CommandNode)searchUsageNode);
        searchUsageNode.addChild((CommandNode)searchUsageFunctionNode);
        searchNode.addChild((CommandNode)searchUnusedNode);
        searchNode.addChild((CommandNode)searchEventNode);
        searchEventNode.addChild((CommandNode)searchEventNameNode);
        searchNode.addChild((CommandNode)searchInvalidNode);
        searchNode.addChild((CommandNode)searchDefinitionFunctionNode);
        dispatcher.getRoot().addChild((CommandNode)searchNode);
    }
}

