/*
 * Decompiled with CFR 0.152.
 */
package me.white.justutils.value;

import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.List;
import me.white.justutils.TextParser;
import me.white.justutils.Value;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class GameValue
implements Value {
    private static final String TYPE = "game_value";

    @Override
    public String getText(class_1799 stack) {
        class_2487 value = Value.getValueNbt(stack);
        String game = (String)value.method_10558(TYPE).orElseThrow();
        String selection = (String)value.method_10558("selection").orElseThrow();
        try {
            selection = JsonParser.parseString((String)selection).getAsJsonObject().get("type").getAsString();
        }
        catch (JsonParseException | IllegalStateException | UnsupportedOperationException ignored) {
            selection = "";
        }
        return (selection + " " + game).strip();
    }

    @Override
    public class_1799 parse(String text) {
        text = text.strip();
        Selection selection = Selection.CURRENT;
        for (Selection variant : Selection.values()) {
            if (!text.startsWith(variant.id + " ") && !text.equals(variant.id)) continue;
            selection = variant;
            if ((text = text.substring(variant.id.length())).isEmpty()) break;
            text = text.substring(1);
            break;
        }
        class_2487 value = new class_2487();
        value.method_10582("type", TYPE);
        value.method_10582("selection", String.format("{\"type\":\"%s\"}", selection.id));
        value.method_10582(TYPE, text);
        return Value.construct(class_1802.field_8448, value, (class_2561)class_2561.method_43470((String)text).method_10862(Value.BLANK_STYLE), List.of(selection.lore));
    }

    private static enum Selection {
        CURRENT("current", (class_2561)TextParser.parseLegacy("&7\u0426\u0435\u043b\u044c: &f\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0446\u0435\u043b\u044c")),
        DEFAULT("default", (class_2561)TextParser.parseLegacy("&7\u0426\u0435\u043b\u044c: &f\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e")),
        DEFAULT_ENTITY("default_entity", (class_2561)TextParser.parseLegacy("&7\u0426\u0435\u043b\u044c: &f\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u043e \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e")),
        KILLER_ENTITY("killer_entity", (class_2561)TextParser.parseLegacy("&7\u0426\u0435\u043b\u044c: &f\u0423\u0431\u0438\u0439\u0446\u0430")),
        DAMAGER_ENTITY("damager_entity", (class_2561)TextParser.parseLegacy("&7\u0426\u0435\u043b\u044c: &f\u0410\u0442\u0430\u043a\u0443\u044e\u0449\u0438\u0439")),
        VICTIM_ENTITY("victim_entity", (class_2561)TextParser.parseLegacy("&7\u0426\u0435\u043b\u044c: &f\u0416\u0435\u0440\u0442\u0432\u0430")),
        SHOOTER_ENTITY("shooter_entity", (class_2561)TextParser.parseLegacy("&7\u0426\u0435\u043b\u044c: &f\u0421\u0442\u0440\u0435\u043b\u043e\u043a")),
        PROJECTILE("projectile", (class_2561)TextParser.parseLegacy("&7\u0426\u0435\u043b\u044c: &f\u0421\u043d\u0430\u0440\u044f\u0434")),
        LAST_ENTITY("last_entity", (class_2561)TextParser.parseLegacy("&7\u0426\u0435\u043b\u044c: &f\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c"));

        final String id;
        final class_2561 lore;

        private Selection(String id, class_2561 lore) {
            this.id = id;
            this.lore = lore;
        }
    }
}

