/*
 * Decompiled with CFR 0.152.
 */
package me.white.justutils.value;

import java.util.List;
import me.white.justutils.TextParser;
import me.white.justutils.Value;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class LocationValue
implements Value {
    private static final String NAME_FORMAT = "&ax: &f%s&a y: &f%s&a z: &f%s";
    private static final String NAME_EXTENDED_FORMAT = "&ax: &f%s&a y: &f%s&a z: &f%s&a yaw: &f%s&a pitch: &f%s";
    private static final String TYPE = "location";

    @Override
    public String getText(class_1799 stack) {
        class_2487 value = Value.getValueNbt(stack);
        String x = Value.doubleToString((Double)value.method_10574("x").orElseThrow());
        String y = Value.doubleToString((Double)value.method_10574("y").orElseThrow());
        String z = Value.doubleToString((Double)value.method_10574("z").orElseThrow());
        if (!value.method_10545("yaw") && !value.method_10545("pitch")) {
            return String.format("%s %s %s", x, y, z);
        }
        String yaw = Value.doubleToString((Double)value.method_10574("yaw").orElseThrow());
        String pitch = Value.doubleToString((Double)value.method_10574("pitch").orElseThrow());
        return String.format("%s %s %s %s %s", x, y, z, yaw, pitch);
    }

    @Override
    public class_1799 parse(String text) {
        String[] parts = text.strip().split(" +");
        double[] components = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        for (int i = 0; i < 5 && i < parts.length; ++i) {
            try {
                components[i] = Double.parseDouble(parts[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        class_5250 name = TextParser.parseLegacy(String.format(NAME_FORMAT, Value.doubleToString(components[0]), Value.doubleToString(components[1]), Value.doubleToString(components[2])));
        class_2487 value = new class_2487();
        value.method_10582("type", TYPE);
        value.method_10549("x", components[0]);
        value.method_10549("y", components[1]);
        value.method_10549("z", components[2]);
        if (parts.length > 3) {
            value.method_10549("yaw", components[3]);
            value.method_10549("pitch", components[4]);
            name = TextParser.parseLegacy(String.format(NAME_EXTENDED_FORMAT, Value.doubleToString(components[0]), Value.doubleToString(components[1]), Value.doubleToString(components[2]), Value.doubleToString(components[3]), Value.doubleToString(components[4])));
        }
        return Value.construct(class_1802.field_8407, value, (class_2561)name, List.of());
    }
}

