/*
 * Decompiled with CFR 0.152.
 */
package me.white.justutils.value;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import me.white.justutils.TextParser;
import me.white.justutils.Value;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_8824;

public class TextValue
implements Value {
    private static final String TYPE = "text";

    @Override
    public String getText(class_1799 stack) {
        class_2487 value = Value.getValueNbt(stack);
        String parsing = (String)value.method_10558("parsing").orElseThrow();
        String text = (String)value.method_10558(TYPE).orElseThrow();
        return (parsing + " " + text).strip();
    }

    @Override
    public class_1799 parse(String text) {
        text = text.strip();
        TextParsing parsing = TextParsing.PLAIN;
        for (TextParsing variant : TextParsing.values()) {
            if (!text.startsWith(variant.id + " ") && !text.equals(variant.id)) continue;
            parsing = variant;
            if ((text = text.substring(variant.id.length())).isEmpty()) break;
            text = text.substring(1);
            break;
        }
        text = text.replaceAll("(?<!%)%empty%", "");
        text = text.replaceAll("(?<!%)%space%", " ");
        text = text.replaceAll("%%empty%", "%empty%");
        text = text.replaceAll("%%space%", "%space%");
        class_2487 value = new class_2487();
        value.method_10582("type", TYPE);
        value.method_10582("parsing", parsing.id);
        value.method_10582(TYPE, text);
        ArrayList<class_2561> lore = new ArrayList<class_2561>(parsing.lore);
        lore.add((class_2561)class_2561.method_43470((String)text).method_10862(Value.BLANK_STYLE.method_10977(class_124.field_1068)));
        return Value.construct(class_1802.field_8529, value, parsing.parse(text), lore);
    }

    private static enum TextParsing {
        PLAIN("plain", List.of(TextParser.parseLegacy("&#ABC4D6\u0422\u0438\u043f: &f\u041e\u0431\u044b\u0447\u043d\u044b\u0439"), TextParser.parseLegacy("&7\u041e\u0431\u044b\u0447\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u0431\u0435\u0437 \u0446\u0432\u0435\u0442\u043e\u0432 \u0438 \u0434\u0435\u043a\u043e\u0440\u0430\u0446\u0438\u0439"), TextParser.parseLegacy("&#ABC4D6\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0432\u0438\u0434:"))){

            @Override
            public class_2561 parse(String text) {
                return class_2561.method_43470((String)text).method_10862(Value.BLANK_STYLE);
            }
        }
        ,
        LEGACY("legacy", List.of(TextParser.parseLegacy("&#ABC4D6\u0422\u0438\u043f: &e\u0426\u0432\u0435\u0442\u043d\u043e\u0439"), TextParser.parseLegacy("&7\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0446\u0432\u0435\u0442\u0430 \u0438 \u0434\u0435\u043a\u043e\u0440\u0430\u0446\u0438\u0438 (&\u0446\u0432\u0435\u0442)"), TextParser.parseLegacy("&#ABC4D6\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0432\u0438\u0434:"))){

            @Override
            public class_2561 parse(String text) {
                return TextParser.parseLegacy(text);
            }
        }
        ,
        MINIMESSAGE("minimessage", List.of(TextParser.parseLegacy("&#ABC4D6\u0422\u0438\u043f: &#A6FF6E\u0421\u0442\u0438\u043b\u0438\u0437\u0443\u0435\u043c\u044b\u0439"), TextParser.parseLegacy("&7\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u0442\u0438\u043b\u0438 \u0444\u043e\u0440\u043c\u0430\u0442\u0430 MiniMessage"), TextParser.parseLegacy("&#ABC4D6\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0432\u0438\u0434:"))){

            @Override
            public class_2561 parse(String text) {
                return class_2561.method_43470((String)"\u041a\u0430\u043a \u044d\u0442\u043e \u043f\u0430\u0440\u0441\u0438\u0442\u044c?").method_10862(Value.BLANK_STYLE);
            }
        }
        ,
        JSON("json", List.of(TextParser.parseLegacy("&#ABC4D6\u0422\u0438\u043f: &#FFB657JSON"), TextParser.parseLegacy("&7\u0422\u0435\u043a\u0441\u0442 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 JSON"), TextParser.parseLegacy("&#ABC4D6\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0432\u0438\u0434:"))){

            @Override
            public class_2561 parse(String text) {
                try {
                    return ((class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)class_310.method_1551().method_1562().method_29091().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)JsonParser.parseString((String)text)).getOrThrow()).getFirst()).method_27661();
                }
                catch (Exception ignored) {
                    return class_2561.method_43470((String)text).method_10862(Value.BLANK_STYLE);
                }
            }
        };

        final String id;
        final List<class_2561> lore;

        private TextParsing(String id, List<class_2561> lore) {
            this.id = id;
            this.lore = lore;
        }

        public class_2561 parse(String text) {
            throw new UnsupportedOperationException();
        }
    }
}

