/*
 * Decompiled with CFR 0.152.
 */
package lillouarts.placeablefood.procedures;

import lillouarts.placeablefood.block.BowlOfApplesBlock;
import lillouarts.placeablefood.init.PlaceableFoodModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BowlOfApplesOnBlockRightClickedProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        BlockState state = world.getBlockState(pos);
        if (!state.is((Block)PlaceableFoodModBlocks.BOWL_OF_APPLES.get())) {
            return;
        }
        if (!state.hasProperty((Property)BowlOfApplesBlock.STAGE)) {
            return;
        }
        int stage = (Integer)state.getValue((Property)BowlOfApplesBlock.STAGE);
        if (stage >= 7) {
            BowlOfApplesOnBlockRightClickedProcedure.destroy(world, pos);
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                BowlOfApplesOnBlockRightClickedProcedure.spawnBowl(level, x, y, z);
            }
            return;
        }
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            BowlOfApplesOnBlockRightClickedProcedure.spawnApple(level, x, y, z);
        }
        world.setBlock(pos, (BlockState)state.setValue((Property)BowlOfApplesBlock.STAGE, (Comparable)Integer.valueOf(stage + 1)), 3);
    }

    private static void spawnApple(ServerLevel level, double x, double y, double z) {
        ItemEntity e = new ItemEntity((Level)level, x + 0.5, y + 0.8, z + 0.5, new ItemStack((ItemLike)Items.APPLE));
        e.setPickUpDelay(10);
        level.addFreshEntity((Entity)e);
    }

    private static void spawnBowl(ServerLevel level, double x, double y, double z) {
        ItemEntity e = new ItemEntity((Level)level, x + 0.5, y + 0.8, z + 0.5, new ItemStack((ItemLike)Items.BOWL));
        e.setPickUpDelay(10);
        level.addFreshEntity((Entity)e);
    }

    private static void destroy(LevelAccessor world, BlockPos pos) {
        if (world instanceof Level) {
            Level lvl = (Level)world;
            lvl.destroyBlock(pos, false);
        } else {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }
}

