/*
 * Decompiled with CFR 0.152.
 */
package lillouarts.placeablefood.block;

import java.util.Collections;
import java.util.List;
import lillouarts.placeablefood.procedures.GpieOnBlockRightClickedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GpieBlock
extends Block {
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)3);

    public GpieBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOL).strength(1.0f, 10.0f).lightLevel(s -> 1).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{STAGE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(0));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return GpieBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.5, (double)14.0);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if ((Integer)state.getValue((Property)STAGE) != 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }

    public InteractionResult useWithoutItem(BlockState s, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            GpieOnBlockRightClickedProcedure.execute((LevelAccessor)level, pos.getX(), pos.getY(), pos.getZ(), (Entity)player);
        }
        return InteractionResult.SUCCESS;
    }
}

