/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.config;

import com.greymerk.roguelike.config.ConfigSettings;
import com.greymerk.roguelike.util.MixedKey;
import java.util.Optional;

public enum Config {
    FREQUENCY("frequency"),
    MOB_DROPS("mob_drops"),
    DEBUG("debug"),
    BELOW_SEA_LEVEL("below_sea_level"),
    ROOMS_PER_LEVEL("rooms_per_level"),
    ROGUELIKE_LOOT("roguelike_loot"),
    DETERMINISTIC("deterministic"),
    DISTANCE_TO_VILLAGE("distance_to_village");

    private final String key;

    private Config(String key) {
        this.key = key;
    }

    public String keyOf() {
        return this.key;
    }

    public String toString() {
        return this.key;
    }

    public static Boolean ofBoolean(Config type) {
        ConfigSettings settings = ConfigSettings.getInstance();
        return settings.get(MixedKey.ofBoolean(type.keyOf()));
    }

    public static Double ofDouble(Config type) {
        ConfigSettings settings = ConfigSettings.getInstance();
        return settings.get(MixedKey.ofDouble(type.keyOf()));
    }

    public static Optional<Integer> ofInteger(Config type) {
        MixedKey<Integer> key;
        ConfigSettings settings = ConfigSettings.getInstance();
        if (settings.has(key = MixedKey.ofInteger(type.keyOf()))) {
            return Optional.of(settings.get(key));
        }
        return Optional.empty();
    }

    public static String ofString(Config type) {
        ConfigSettings settings = ConfigSettings.getInstance();
        return settings.get(MixedKey.ofString(type.keyOf()));
    }
}

