/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon;

public enum Difficulty {
    EASIEST(0),
    EASY(1),
    MEDIUM(2),
    HARD(3),
    HARDEST(4);

    public final int value;

    private Difficulty(int i) {
        this.value = i;
    }

    public boolean gt(Difficulty other) {
        return this.compareTo(other) > 0;
    }

    public boolean lt(Difficulty other) {
        return this.compareTo(other) < 0;
    }

    public static Difficulty from(int ord) {
        if (ord < 0) {
            return EASIEST;
        }
        if (ord > Difficulty.values().length - 1) {
            return HARDEST;
        }
        return Difficulty.values()[ord];
    }

    public static int value(Difficulty diff) {
        return diff.value;
    }
}

