/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon;

import com.google.common.base.Stopwatch;
import com.greymerk.roguelike.debug.Debug;
import com.greymerk.roguelike.dungeon.layout.ExclusionZones;
import com.greymerk.roguelike.dungeon.layout.LayoutManager;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.dungeon.room.Room;
import com.greymerk.roguelike.dungeon.tower.RogueTower;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.Statistics;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.settings.LevelSettings;
import com.greymerk.roguelike.state.RoguelikeState;
import com.greymerk.roguelike.theme.Theme;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_5819;

public class Dungeon
implements Iterable<IRoom> {
    List<IRoom> rooms;
    Coord origin;
    BoundingBox bb;
    public static final Codec<List<IRoom>> LIST_ROOM_CODEC = Codec.list(Room.CODEC);
    public static final Codec<Dungeon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LIST_ROOM_CODEC.fieldOf("rooms").forGetter(dungeon -> dungeon.rooms), (App)Coord.CODEC.fieldOf("pos").forGetter(dungeon -> dungeon.origin), (App)BoundingBox.CODEC.fieldOf("bounds").forGetter(dungeon -> dungeon.bb)).apply((Applicative)instance, Dungeon::new));

    public static boolean generate(IWorldEditor editor, Coord pos) {
        return Dungeon.generate(editor, pos, false);
    }

    public static boolean generate(IWorldEditor editor, Coord pos, boolean force) {
        if (!Dungeon.canSpawn(editor, pos) && !force) {
            return false;
        }
        Dungeon donjon = new Dungeon(pos.copy());
        donjon.generate(editor);
        editor.getInfo().getState().addDungeon(donjon);
        RoguelikeState.flagForGenerationCheck = true;
        return true;
    }

    public Dungeon(Coord pos) {
        this.rooms = new ArrayList<IRoom>();
        this.bb = BoundingBox.of(pos.copy());
        this.origin = pos;
    }

    public Dungeon(List<IRoom> rooms, Coord origin, BoundingBox bb) {
        this.rooms = rooms;
        this.origin = origin;
        this.bb = bb;
    }

    public static boolean canSpawn(IWorldEditor editor, Coord pos) {
        if (!editor.getInfo().isOverworld()) {
            return false;
        }
        ExclusionZones zones = new ExclusionZones();
        int SCAN_DISTANCE = 300;
        int COLLISION_RANGE = 50;
        zones.scan(editor, pos, 300);
        if (zones.collides(pos.withY(0), 50)) {
            Debug.info("Dungeon @" + pos.toString() + " failed: nearby trial chamber");
            return false;
        }
        Coord surface = editor.findSurface(pos);
        MetaBlock block = editor.getBlock(surface);
        if (!block.isGround()) {
            Debug.info("Dungeon @" + surface.toString() + " failed: " + block.getBlock().toString() + " isn't valid ground");
            return false;
        }
        return true;
    }

    public void generate(IWorldEditor editor) {
        class_5819 rand = editor.getRandom(this.origin);
        Stopwatch watch = Stopwatch.createStarted();
        Coord surface = editor.findSurface(this.origin);
        this.origin = surface.copy().freeze();
        Coord entry = this.origin.withY(editor.getDungeonEntryDepth(this.origin)).freeze();
        LayoutManager layout = new LayoutManager(this.origin, entry, editor.getInfo().getLastFloorDepth());
        IRoom entrance = Room.getInstance(Room.ENTRANCE, LevelSettings.fromType(LevelSettings.OAK), Coord.ZERO, entry);
        entrance.generate(editor);
        entrance.setGenerated(true);
        layout.addEntrance(entrance);
        layout.generate(editor);
        this.rooms = layout.getRooms();
        this.rooms.forEach(r -> this.bb.combine(r.getBoundingBox().get()));
        RogueTower tower = new RogueTower();
        tower.generate(editor, rand, Theme.getTheme(Theme.TOWER), entry);
        Debug.info("Dungeon @" + String.valueOf(surface) + " generated layout in: " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms");
    }

    public boolean hasLayout() {
        return this.rooms.size() > 0;
    }

    public boolean isGenerated() {
        return this.hasLayout() && this.rooms.stream().allMatch(room -> room.isGenerated());
    }

    public IBounded getBounds() {
        return this.bb;
    }

    public Coord getPos() {
        return this.origin.copy();
    }

    public Statistics getStatistics() {
        Statistics combined = new Statistics();
        this.rooms.forEach(r -> combined.merge(r.getStats()));
        return combined;
    }

    @Override
    public Iterator<IRoom> iterator() {
        return this.rooms.iterator();
    }
}

