/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.fragment;

import com.greymerk.roguelike.dungeon.fragment.IFragment;
import com.greymerk.roguelike.dungeon.fragment.alcove.BookShelfAlcove;
import com.greymerk.roguelike.dungeon.fragment.alcove.FireAlcove;
import com.greymerk.roguelike.dungeon.fragment.alcove.PrisonAlcove;
import com.greymerk.roguelike.dungeon.fragment.alcove.SafetyCell;
import com.greymerk.roguelike.dungeon.fragment.alcove.SilverfishNest;
import com.greymerk.roguelike.dungeon.fragment.alcove.TombAlcove;
import com.greymerk.roguelike.dungeon.fragment.parts.ArchWay;
import com.greymerk.roguelike.dungeon.fragment.parts.CellSupport;
import com.greymerk.roguelike.dungeon.fragment.parts.CryptFragment;
import com.greymerk.roguelike.dungeon.fragment.parts.Fungus;
import com.greymerk.roguelike.dungeon.fragment.parts.Sarcophagus;
import com.greymerk.roguelike.dungeon.fragment.wall.WallBannerFragment;
import com.greymerk.roguelike.dungeon.fragment.wall.WallCandles;
import com.greymerk.roguelike.dungeon.fragment.wall.WallChest;
import com.greymerk.roguelike.dungeon.fragment.wall.WallDecoratedPot;
import com.greymerk.roguelike.dungeon.fragment.wall.WallEmpty;
import com.greymerk.roguelike.dungeon.fragment.wall.WallFlowers;
import com.greymerk.roguelike.dungeon.fragment.wall.WallFoodBarrel;
import com.greymerk.roguelike.dungeon.fragment.wall.WallMushrooms;
import com.greymerk.roguelike.dungeon.fragment.wall.WallPlant;
import com.greymerk.roguelike.dungeon.fragment.wall.WallSkulls;
import com.greymerk.roguelike.dungeon.fragment.wall.WallSpawner;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.settings.ILevelSettings;
import net.minecraft.class_5819;

public enum Fragment {
    CRYPT,
    SARCOPHAGUS,
    FUNGUS,
    CELL_SUPPORT,
    ARCH,
    WALL_FLOWER,
    WALL_BANNER,
    WALL_CHEST,
    WALL_SPAWNER,
    WALL_CANDLES,
    WALL_EMPTY,
    WALL_DECORATED_POT,
    WALL_FOOD_BARREL,
    WALL_PLANT,
    WALL_MUSHROOMS,
    WALL_SKULLS,
    ALCOVE_SILVERFISH,
    ALCOVE_SAFETY,
    ALCOVE_CRYPT,
    BOOK_SHELF,
    ALCOVE_FIRE,
    ALCOVE_PRISON_CELL;


    public static void generate(Fragment type, IWorldEditor editor, class_5819 rand, ILevelSettings settings, Coord pos, Cardinal dir) {
        IFragment fragment = Fragment.fromType(type);
        fragment.generate(editor, rand, settings, pos.freeze(), dir);
    }

    public static IFragment fromType(Fragment type) {
        switch (type.ordinal()) {
            case 3: {
                return new CellSupport();
            }
            case 0: {
                return new CryptFragment();
            }
            case 1: {
                return new Sarcophagus();
            }
            case 4: {
                return new ArchWay();
            }
            case 5: {
                return new WallFlowers();
            }
            case 6: {
                return new WallBannerFragment();
            }
            case 8: {
                return new WallSpawner();
            }
            case 7: {
                return new WallChest();
            }
            case 9: {
                return new WallCandles();
            }
            case 10: {
                return new WallEmpty();
            }
            case 11: {
                return new WallDecoratedPot();
            }
            case 14: {
                return new WallMushrooms();
            }
            case 12: {
                return new WallFoodBarrel();
            }
            case 13: {
                return new WallPlant();
            }
            case 15: {
                return new WallSkulls();
            }
            case 16: {
                return new SilverfishNest();
            }
            case 17: {
                return new SafetyCell();
            }
            case 18: {
                return new TombAlcove();
            }
            case 20: {
                return new FireAlcove();
            }
            case 21: {
                return new PrisonAlcove();
            }
            case 19: {
                return new BookShelfAlcove();
            }
            case 2: {
                return new Fungus();
            }
        }
        return new WallEmpty();
    }
}

