/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.fragment.parts;

import com.greymerk.roguelike.dungeon.fragment.IFragment;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Lantern;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.shapes.Column;
import com.greymerk.roguelike.settings.ILevelSettings;
import com.greymerk.roguelike.theme.ITheme;
import net.minecraft.class_5819;

public class CellSupport
implements IFragment {
    public static void generate(IWorldEditor editor, class_5819 rand, ITheme theme, Coord origin) {
        CellSupport.generate(editor, rand, theme, origin, Cardinal.NORTH);
    }

    public static void generate(IWorldEditor editor, class_5819 rand, ITheme theme, Coord origin, Cardinal d) {
        Coord pos;
        IBlockFactory wall = theme.getPrimary().getWall();
        for (Cardinal dir : Cardinal.directions) {
            pos = origin.copy();
            pos.add(dir, 2);
            pos.add(Cardinal.left(dir), 2);
            pos.add(Cardinal.DOWN, 2);
            Column.fillDown(editor, rand, wall, pos.copy());
        }
        for (Cardinal dir : Cardinal.directions) {
            pos = origin.copy();
            pos.add(dir, 2);
            pos.add(Cardinal.DOWN, 2);
            for (Coord p : new Column(pos).getUntilSolid(editor)) {
                if (Math.floorMod(p.getY(), 10) != 9 && Math.floorMod(p.getY(), 10) != 3) continue;
                CellSupport.crossBar(editor, rand, theme, p, dir);
            }
        }
    }

    @Override
    public void generate(IWorldEditor editor, class_5819 rand, ILevelSettings settings, Coord origin, Cardinal d) {
        CellSupport.generate(editor, rand, settings.getTheme(), origin, d);
    }

    public static void crossBar(IWorldEditor editor, class_5819 rand, ITheme theme, Coord origin, Cardinal dir) {
        Coord pos;
        IBlockFactory wall = theme.getPrimary().getWall();
        IStair stair = theme.getPrimary().getStair();
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            pos = origin.copy().add(o, 2);
            if (editor.isSolid(pos)) continue;
            return;
        }
        wall.set(editor, rand, origin, Fill.AIR);
        for (Cardinal o : Cardinal.orthogonal(dir)) {
            pos = origin.copy().add(o);
            wall.set(editor, rand, pos, Fill.AIR);
            pos.add(Cardinal.DOWN);
            stair.setOrientation(Cardinal.reverse(o), true);
            stair.set(editor, rand, pos, Fill.AIR);
        }
        if (rand.method_43048(10) == 0) {
            Coord pos2 = origin.copy().add(Cardinal.DOWN);
            Lantern.set(editor, pos2, theme, true);
        }
    }
}

