/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.fragment.parts;

import com.greymerk.roguelike.dungeon.fragment.IFragment;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.Fill;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.spawners.Spawner;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.Line;
import com.greymerk.roguelike.settings.ILevelSettings;
import com.greymerk.roguelike.util.math.RandHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_5819;

public class SpiderNest
implements IFragment {
    public static void generate(IWorldEditor editor, class_5819 rand, ILevelSettings settings, Coord origin) {
        new SpiderNest().generate(editor, rand, settings, origin, Cardinal.NORTH);
    }

    @Override
    public void generate(IWorldEditor editor, class_5819 rand, ILevelSettings settings, Coord origin, Cardinal dir) {
        if (!this.validLocation(editor, origin)) {
            return;
        }
        Spawner.generate(editor, rand, settings.getDifficulty(), origin, Spawner.CAVESPIDER);
        List<Coord> ends = RandHelper.pickCountFrom(this.findSolids(editor, origin, 8), rand, 10);
        ends.forEach(end -> this.getStrand(editor, origin, (Coord)end).ifPresent(strand -> strand.forEach(c -> strand.fill(editor, rand, MetaBlock.of(class_2246.field_10343), Fill.AIR))));
    }

    private Optional<Line> getStrand(IWorldEditor editor, Coord start, Coord end) {
        List segments = Line.of(start, end).get().stream().sorted((a, b) -> (int)(Math.round(start.distance((Coord)b)) - Math.round(start.distance((Coord)a)))).toList();
        for (Coord c : segments) {
            if (c.equals(start) || !editor.isSupported(c)) continue;
            return Optional.of(Line.of(start, c));
        }
        return Optional.empty();
    }

    private List<Coord> findSolids(IWorldEditor editor, Coord origin, int range) {
        return BoundingBox.of(origin).grow(Cardinal.all, range).get().stream().filter(c -> editor.isSolid((Coord)c) && editor.isSupported((Coord)c)).toList();
    }

    private boolean validLocation(IWorldEditor editor, Coord origin) {
        for (Coord c : BoundingBox.of(origin).grow(Cardinal.all)) {
            if (editor.isAir(c)) continue;
            return false;
        }
        return true;
    }
}

