/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.layout;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.util.StructureLocator;
import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ExclusionZones {
    private Set<Zone> zones = new HashSet<Zone>();
    private static int SIZE_OF_ZONES = 50;

    public boolean collides(IBounded box) {
        for (Zone zone : this.zones) {
            if (!zone.collide(box)) continue;
            return true;
        }
        return false;
    }

    public boolean collides(Coord pos, int range) {
        return this.collides(BoundingBox.of(Coord.of(pos.getX(), 0, pos.getZ())).grow(Cardinal.directions, range).grow(List.of(Cardinal.UP, Cardinal.DOWN), 64));
    }

    public void scan(IWorldEditor editor, Coord pos, int range) {
        Set<Coord> structureLocations = StructureLocator.scan(editor, pos, StructureLocator.UNDERGROUND, range);
        structureLocations.forEach(location -> this.zones.add(Zone.of(location)));
    }

    public Optional<Coord> nearest(Coord pos) {
        if (this.zones.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((Zone)this.zones.stream().min((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$nearest$1(com.greymerk.roguelike.editor.Coord com.greymerk.roguelike.dungeon.layout.ExclusionZones$Zone com.greymerk.roguelike.dungeon.layout.ExclusionZones$Zone ), (Lcom/greymerk/roguelike/dungeon/layout/ExclusionZones$Zone;Lcom/greymerk/roguelike/dungeon/layout/ExclusionZones$Zone;)I)((Coord)pos)).get()).origin);
    }

    public String toString() {
        return "Zones: " + this.zones.size() + " : " + List.of(this.zones).toString();
    }

    private static /* synthetic */ int lambda$nearest$1(Coord pos, Zone a, Zone b) {
        return (int)(a.origin.distance(pos) - b.origin.distance(pos));
    }

    private static class Zone {
        private Coord origin;
        private BoundingBox bb;

        public static Zone of(Coord origin) {
            return new Zone(origin);
        }

        private Zone(Coord origin) {
            this.origin = origin;
            this.bb = BoundingBox.of(origin).grow(Cardinal.directions, SIZE_OF_ZONES).grow(List.of(Cardinal.UP, Cardinal.DOWN), 64);
        }

        public boolean collide(IBounded box) {
            return box.collide(this.bb);
        }

        public String toString() {
            return this.origin.toString();
        }

        public int hashCode() {
            return Objects.hash(this.bb, this.origin);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Zone other = (Zone)obj;
            return Objects.equals(this.bb, other.bb) && Objects.equals(this.origin, other.origin);
        }
    }
}

